"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.QueryTabContentComponent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactReversePortal = require("react-reverse-portal");
var _common = require("@kbn/data-plugin/common");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _memoizeOne = _interopRequireDefault(require("memoize-one"));
var _use_selector = require("../../../../../common/hooks/use_selector");
var _use_experimental_features = require("../../../../../common/hooks/use_experimental_features");
var _constants = require("../../../../../common/store/inputs/constants");
var _use_invalid_filter_query = require("../../../../../common/hooks/use_invalid_filter_query");
var _store = require("../../../../store");
var _containers = require("../../../../containers");
var _kibana = require("../../../../../common/lib/kibana");
var _default_headers = require("../../body/column_headers/default_headers");
var _body = require("../../body");
var _footer = require("../../footer");
var _header = require("./header");
var _helpers = require("../../helpers");
var _kuery = require("../../../../../common/lib/kuery");
var _refetch_timeline = require("../../refetch_timeline");
var _timeline = require("../../../../../../common/types/timeline");
var _default_config = require("../../../../../detections/components/alerts_table/default_config");
var _event_details_width_context = require("../../../../../common/components/events_viewer/event_details_width_context");
var _store2 = require("../../../../../common/store");
var _model = require("../../../../../common/store/sourcerer/model");
var _defaults = require("../../../../store/defaults");
var _sourcerer = require("../../../../../common/containers/sourcerer");
var _use_timeline_events_count = require("../../../../../common/hooks/use_timeline_events_count");
var _use_full_screen = require("../../../../../common/containers/use_full_screen");
var _side_panel = require("../../../side_panel");
var _exit_full_screen = require("../../../../../common/components/exit_full_screen");
var _control_columns = require("../../body/control_columns");
var _use_license = require("../../../../../common/hooks/use_license");
var _header_actions = require("../../../../../common/components/header_actions/header_actions");
var _default_headers2 = require("../../unified_components/default_headers");
var _unified_timeline_body = require("../../body/unified_timeline_body");
var _helpers2 = require("../../body/column_headers/helpers");
var _layout = require("../shared/layout");
var _utils = require("../shared/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const memoizedGetColumnHeaders = (0, _memoizeOne.default)(_helpers2.getColumnHeaders);
const compareQueryProps = (prevProps, nextProps) => prevProps.kqlMode === nextProps.kqlMode && prevProps.kqlQueryExpression === nextProps.kqlQueryExpression && (0, _fastDeepEqual.default)(prevProps.filters, nextProps.filters);
const trailingControlColumns = []; // stable reference

const QueryTabContentComponent = ({
  activeTab,
  columns,
  dataProviders,
  end,
  filters,
  timelineId,
  isLive,
  itemsPerPage,
  itemsPerPageOptions,
  kqlMode,
  kqlQueryExpression,
  kqlQueryLanguage,
  onEventClosed,
  renderCellValue,
  rowRenderers,
  show,
  showCallOutUnauthorizedMsg,
  showExpandedDetails,
  start,
  status,
  sort,
  timerangeKind,
  expandedDetail
}) => {
  var _pageInfo$activePage;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    portalNode: timelineEventsCountPortalNode
  } = (0, _use_timeline_events_count.useTimelineEventsCountPortal)();
  const {
    setTimelineFullScreen,
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const {
    browserFields,
    dataViewId,
    loading: loadingSourcerer,
    indexPattern,
    runtimeMappings,
    // important to get selectedPatterns from useSourcererDataView
    // in order to include the exclude filters in the search that are not stored in the timeline
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const {
    uiSettings,
    timelineFilterManager
  } = (0, _kibana.useKibana)().services;
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const ACTION_BUTTON_COUNT = isEnterprisePlus ? 6 : 5;
  const unifiedComponentsInTimelineEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('unifiedComponentsInTimelineEnabled');
  const getManageTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const currentTimeline = (0, _use_selector.useDeepEqualSelector)(state => getManageTimeline(state, timelineId !== null && timelineId !== void 0 ? timelineId : _timeline.TimelineId.active));
  const {
    sampleSize
  } = currentTimeline;
  const esQueryConfig = (0, _react.useMemo)(() => (0, _common.getEsQueryConfig)(uiSettings), [uiSettings]);
  const kqlQuery = (0, _react.useMemo)(() => ({
    query: kqlQueryExpression.trim(),
    language: kqlQueryLanguage
  }), [kqlQueryExpression, kqlQueryLanguage]);
  const combinedQueries = (0, _kuery.combineQueries)({
    config: esQueryConfig,
    dataProviders,
    indexPattern,
    browserFields,
    filters,
    kqlQuery,
    kqlMode
  });
  (0, _use_invalid_filter_query.useInvalidFilterQuery)({
    id: timelineId,
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    kqlError: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.kqlError,
    query: kqlQuery,
    startDate: start,
    endDate: end
  });
  const isBlankTimeline = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)(filters) && (0, _fp.isEmpty)(kqlQuery.query) && (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) === undefined;
  const canQueryTimeline = (0, _react.useMemo)(() => combinedQueries != null && loadingSourcerer != null && !loadingSourcerer && !(0, _fp.isEmpty)(start) && !(0, _fp.isEmpty)(end) && (combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery) !== undefined, [combinedQueries, end, loadingSourcerer, start]);
  const defaultColumns = (0, _react.useMemo)(() => unifiedComponentsInTimelineEnabled ? _default_headers2.defaultUdtHeaders : _default_headers.defaultHeaders, [unifiedComponentsInTimelineEnabled]);
  const localColumns = (0, _react.useMemo)(() => (0, _fp.isEmpty)(columns) ? defaultColumns : columns, [columns, defaultColumns]);
  const augumentedColumnHeaders = memoizedGetColumnHeaders(localColumns, browserFields, false);
  const getTimelineQueryFields = () => {
    const columnFields = augumentedColumnHeaders.map(c => c.id);
    return [...columnFields, ..._default_config.requiredFieldsForActions];
  };
  const timelineQuerySortField = sort.map(({
    columnId,
    columnType,
    esTypes,
    sortDirection
  }) => ({
    field: columnId,
    direction: sortDirection,
    esTypes: esTypes !== null && esTypes !== void 0 ? esTypes : [],
    type: columnType
  }));
  (0, _react.useEffect)(() => {
    dispatch(_store.timelineActions.initializeTimelineSettings({
      id: timelineId,
      defaultColumns
    }));
  }, [dispatch, timelineId, defaultColumns]);
  const [dataLoadingState, {
    events,
    inspect,
    totalCount,
    pageInfo,
    loadPage,
    refreshedAt,
    refetch
  }] = (0, _containers.useTimelineEvents)({
    dataViewId,
    endDate: end,
    fields: getTimelineQueryFields(),
    filterQuery: combinedQueries === null || combinedQueries === void 0 ? void 0 : combinedQueries.filterQuery,
    id: timelineId,
    indexNames: selectedPatterns,
    language: kqlQuery.language,
    limit: unifiedComponentsInTimelineEnabled ? sampleSize : itemsPerPage,
    runtimeMappings,
    skip: !canQueryTimeline,
    sort: timelineQuerySortField,
    startDate: start,
    timerangeKind
  });
  const isQueryLoading = (0, _react.useMemo)(() => [_unifiedDataTable.DataLoadingState.loading, _unifiedDataTable.DataLoadingState.loadingMore].includes(dataLoadingState), [dataLoadingState]);
  const handleOnPanelClosed = (0, _react.useCallback)(() => {
    onEventClosed({
      tabType: _timeline.TimelineTabs.query,
      id: timelineId
    });
  }, [onEventClosed, timelineId]);
  (0, _react.useEffect)(() => {
    dispatch(_store.timelineActions.updateIsLoading({
      id: timelineId,
      isLoading: isQueryLoading || loadingSourcerer
    }));
  }, [loadingSourcerer, timelineId, isQueryLoading, dispatch]);
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT).map(x => ({
    ...x,
    headerCellRender: _header_actions.HeaderActions
  })), [ACTION_BUTTON_COUNT]);

  // NOTE: The timeline is blank after browser FORWARD navigation (after using back button to navigate to
  // the previous page from the timeline), yet we still see total count. This is because the timeline
  // is not getting refreshed when using browser navigation.
  const showEventsCountBadge = !isBlankTimeline && totalCount >= 0;
  const header = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_layout.StyledEuiFlyoutHeader, {
    "data-test-subj": `${activeTab}-tab-flyout-header`,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: timelineEventsCountPortalNode
  }, showEventsCountBadge ? /*#__PURE__*/_react.default.createElement(_layout.EventsCountBadge, null, totalCount) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column"
  }, !unifiedComponentsInTimelineEnabled && timelineFullScreen && setTimelineFullScreen != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_exit_full_screen.ExitFullScreen, {
    fullScreen: timelineFullScreen,
    setFullScreen: setTimelineFullScreen
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "timeline-date-picker-container"
  }, /*#__PURE__*/_react.default.createElement(_layout.TabHeaderContainer, {
    "data-test-subj": "timelineHeader"
  }, /*#__PURE__*/_react.default.createElement(_header.QueryTabHeader, {
    filterManager: timelineFilterManager,
    show: show && activeTab === _timeline.TimelineTabs.query,
    showCallOutUnauthorizedMsg: showCallOutUnauthorizedMsg,
    status: status,
    timelineId: timelineId
  }))))), [activeTab, timelineFilterManager, show, showCallOutUnauthorizedMsg, status, timelineId, setTimelineFullScreen, timelineFullScreen, unifiedComponentsInTimelineEnabled, timelineEventsCountPortalNode, showEventsCountBadge, totalCount]);
  if (unifiedComponentsInTimelineEnabled) {
    return /*#__PURE__*/_react.default.createElement(_unified_timeline_body.UnifiedTimelineBody, {
      header: header,
      columns: augumentedColumnHeaders,
      rowRenderers: rowRenderers,
      timelineId: timelineId,
      itemsPerPage: itemsPerPage,
      itemsPerPageOptions: itemsPerPageOptions,
      sort: sort,
      events: events,
      refetch: refetch,
      dataLoadingState: dataLoadingState,
      totalCount: isBlankTimeline ? 0 : totalCount,
      onEventClosed: onEventClosed,
      expandedDetail: expandedDetail,
      showExpandedDetails: showExpandedDetails,
      onChangePage: loadPage,
      activeTab: activeTab,
      updatedAt: refreshedAt,
      isTextBasedQuery: false,
      pageInfo: pageInfo
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_refetch_timeline.TimelineRefetch, {
    id: `${timelineId}-${_timeline.TimelineTabs.query}`,
    inputId: _constants.InputsModelId.timeline,
    inspect: inspect,
    loading: isQueryLoading,
    refetch: refetch,
    skip: !canQueryTimeline
  }), /*#__PURE__*/_react.default.createElement(_layout.FullWidthFlexGroup, {
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_layout.ScrollableFlexItem, {
    grow: 2
  }, header, /*#__PURE__*/_react.default.createElement(_event_details_width_context.EventDetailsWidthProvider, null, /*#__PURE__*/_react.default.createElement(_layout.StyledEuiFlyoutBody, {
    "data-test-subj": `${_timeline.TimelineTabs.query}-tab-flyout-body`,
    className: "timeline-flyout-body"
  }, /*#__PURE__*/_react.default.createElement(_body.StatefulBody, {
    activePage: pageInfo.activePage,
    browserFields: browserFields,
    data: isBlankTimeline ? _utils.EMPTY_EVENTS : events,
    id: timelineId,
    refetch: refetch,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    sort: sort,
    tabType: _timeline.TimelineTabs.query,
    totalPages: (0, _helpers.calculateTotalPages)({
      itemsCount: totalCount,
      itemsPerPage
    }),
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: trailingControlColumns
  })), /*#__PURE__*/_react.default.createElement(_layout.StyledEuiFlyoutFooter, {
    "data-test-subj": `${_timeline.TimelineTabs.query}-tab-flyout-footer`,
    className: "timeline-flyout-footer"
  }, !isBlankTimeline && /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    activePage: (_pageInfo$activePage = pageInfo === null || pageInfo === void 0 ? void 0 : pageInfo.activePage) !== null && _pageInfo$activePage !== void 0 ? _pageInfo$activePage : 0,
    "data-test-subj": "timeline-footer",
    updatedAt: refreshedAt,
    height: _footer.footerHeight,
    id: timelineId,
    isLive: isLive,
    isLoading: isQueryLoading || loadingSourcerer,
    itemsCount: isBlankTimeline ? 0 : events.length,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    onChangePage: loadPage,
    totalCount: isBlankTimeline ? 0 : totalCount
  })))), showExpandedDetails && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_layout.VerticalRule, null), /*#__PURE__*/_react.default.createElement(_layout.ScrollableFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_side_panel.DetailsPanel, {
    browserFields: browserFields,
    handleOnPanelClosed: handleOnPanelClosed,
    runtimeMappings: runtimeMappings,
    tabType: _timeline.TimelineTabs.query,
    scopeId: timelineId
  })))));
};
exports.QueryTabContentComponent = QueryTabContentComponent;
const makeMapStateToProps = () => {
  const getShowCallOutUnauthorizedMsg = _store.timelineSelectors.getShowCallOutUnauthorizedMsg();
  const getTimeline = _store.timelineSelectors.getTimelineByIdSelector();
  const getKqlQueryTimeline = _store.timelineSelectors.getKqlFilterKuerySelector();
  const getInputsTimeline = _store2.inputsSelectors.getTimelineSelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline, _kqlQueryTimeline$exp, _kqlQueryTimeline$exp2, _kqlQueryTimeline$kin, _expandedDetail$Timel;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const input = getInputsTimeline(state);
    const {
      activeTab,
      columns,
      dataProviders,
      expandedDetail,
      filters,
      itemsPerPage,
      itemsPerPageOptions,
      kqlMode,
      show,
      sort,
      status,
      timelineType
    } = timeline;
    const kqlQueryTimeline = getKqlQueryTimeline(state, timelineId);
    const timelineFilter = kqlMode === 'filter' ? filters || [] : [];

    // return events on empty search
    const kqlQueryExpression = (0, _fp.isEmpty)(dataProviders) && (0, _fp.isEmpty)((_kqlQueryTimeline$exp = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.expression) !== null && _kqlQueryTimeline$exp !== void 0 ? _kqlQueryTimeline$exp : '') && timelineType === 'template' ? ' ' : (_kqlQueryTimeline$exp2 = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.expression) !== null && _kqlQueryTimeline$exp2 !== void 0 ? _kqlQueryTimeline$exp2 : '';
    const kqlQueryLanguage = (0, _fp.isEmpty)(dataProviders) && timelineType === 'template' ? 'kuery' : (_kqlQueryTimeline$kin = kqlQueryTimeline === null || kqlQueryTimeline === void 0 ? void 0 : kqlQueryTimeline.kind) !== null && _kqlQueryTimeline$kin !== void 0 ? _kqlQueryTimeline$kin : 'kuery';
    return {
      activeTab,
      columns,
      dataProviders,
      end: input.timerange.to,
      expandedDetail,
      filters: timelineFilter,
      timelineId,
      isLive: input.policy.kind === 'interval',
      itemsPerPage,
      itemsPerPageOptions,
      kqlMode,
      kqlQueryExpression,
      kqlQueryLanguage,
      showCallOutUnauthorizedMsg: getShowCallOutUnauthorizedMsg(state),
      show,
      showExpandedDetails: !!expandedDetail[_timeline.TimelineTabs.query] && !!((_expandedDetail$Timel = expandedDetail[_timeline.TimelineTabs.query]) !== null && _expandedDetail$Timel !== void 0 && _expandedDetail$Timel.panelView),
      sort,
      start: input.timerange.from,
      status,
      timerangeKind: input.timerange.kind
    };
  };
  return mapStateToProps;
};
const mapDispatchToProps = (dispatch, {
  timelineId
}) => ({
  onEventClosed: args => {
    dispatch(_store.timelineActions.toggleDetailPanel(args));
  }
});
const connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
const QueryTabContent = exports.default = connector( /*#__PURE__*/_react.default.memo(QueryTabContentComponent, (prevProps, nextProps) => compareQueryProps(prevProps, nextProps) && prevProps.activeTab === nextProps.activeTab && (0, _utils.isTimerangeSame)(prevProps, nextProps) && prevProps.isLive === nextProps.isLive && prevProps.itemsPerPage === nextProps.itemsPerPage && prevProps.onEventClosed === nextProps.onEventClosed && prevProps.show === nextProps.show && prevProps.showCallOutUnauthorizedMsg === nextProps.showCallOutUnauthorizedMsg && prevProps.showExpandedDetails === nextProps.showExpandedDetails && prevProps.status === nextProps.status && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.columns, nextProps.columns) && (0, _fastDeepEqual.default)(prevProps.dataProviders, nextProps.dataProviders) && (0, _fastDeepEqual.default)(prevProps.itemsPerPageOptions, nextProps.itemsPerPageOptions) && (0, _fastDeepEqual.default)(prevProps.sort, nextProps.sort)));

// eslint-disable-next-line import/no-default-export