"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireWildcard(require("react"));
var _store = require("../../../../store");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _graph_overlay = require("../../../graph_overlay");
var _use_session_view = require("../session/use_session_view");
var _layout = require("../shared/layout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GraphTabContentComponent = ({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const graphEventId = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, timelineId)) === null || _getTimeline === void 0 ? void 0 : _getTimeline.graphEventId;
  });
  const {
    Navigation
  } = (0, _use_session_view.useSessionViewNavigation)({
    scopeId: timelineId
  });
  const {
    shouldShowDetailsPanel,
    DetailsPanel,
    SessionView
  } = (0, _use_session_view.useSessionView)({
    scopeId: timelineId
  });
  if (!graphEventId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_graph_overlay.GraphOverlay, {
    scopeId: timelineId,
    Navigation: Navigation,
    SessionView: SessionView
  }), shouldShowDetailsPanel && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_layout.VerticalRule, null), /*#__PURE__*/_react.default.createElement(_layout.ScrollableFlexItem, {
    grow: 1
  }, DetailsPanel)));
};
GraphTabContentComponent.displayName = 'GraphTabContentComponent';
const GraphTabContent = exports.default = /*#__PURE__*/_react.default.memo(GraphTabContentComponent);

// eslint-disable-next-line import/no-default-export
module.exports = exports.default;