"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.DiscoverTabContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _styledComponents = require("styled-components");
var _reactQuery = require("@tanstack/react-query");
var _lodash = require("lodash");
var _reactRedux = require("react-redux");
var _actions = require("../../../../store/actions");
var _use_discover_in_timeline_context = require("../../../../../common/components/discover_in_timeline/use_discover_in_timeline_context");
var _sourcerer = require("../../../../../common/containers/sourcerer");
var _kibana = require("../../../../../common/lib/kibana");
var _use_discover_state = require("./use_discover_state");
var _model = require("../../../../../common/store/sourcerer/model");
var _use_set_discover_customizations = require("./customizations/use_set_discover_customizations");
var _styles = require("./styles");
var _store = require("../../../../store");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _defaults = require("../../../../store/defaults");
var _utils = require("./utils");
var _translations = require("./translations");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HideSearchSessionIndicatorBreadcrumbIcon = (0, _styledComponents.createGlobalStyle)`
  [data-test-subj='searchSessionIndicator'] {
    display: none;
  }
`;
const DiscoverTabContent = ({
  timelineId
}) => {
  const history = (0, _reactRouterDom.useHistory)();
  const {
    services: {
      customDataService: discoverDataService,
      discover,
      dataViews: dataViewService,
      savedSearch: savedSearchService
    }
  } = (0, _kibana.useKibana)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    dataViewId
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.detections);
  const [dataView, setDataView] = (0, _react.useState)();
  const [discoverTimerange, setDiscoverTimerange] = (0, _react.useState)();
  const discoverAppStateSubscription = (0, _react.useRef)();
  const discoverInternalStateSubscription = (0, _react.useRef)();
  const discoverSavedSearchStateSubscription = (0, _react.useRef)();
  const discoverTimerangeSubscription = (0, _react.useRef)();
  const {
    discoverStateContainer,
    setDiscoverStateContainer,
    getAppStateFromSavedSearch,
    updateSavedSearch,
    initializeLocalSavedSearch,
    defaultDiscoverAppState
  } = (0, _use_discover_in_timeline_context.useDiscoverInTimelineContext)();
  const {
    discoverAppState,
    discoverSavedSearchState,
    setDiscoverSavedSearchState,
    setDiscoverInternalState,
    setDiscoverAppState
  } = (0, _use_discover_state.useDiscoverState)();
  const discoverCustomizationCallbacks = (0, _use_set_discover_customizations.useSetDiscoverCustomizationCallbacks)();
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const timeline = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
  });
  const {
    status,
    savedSearchId,
    activeTab,
    savedObjectId,
    title,
    description
  } = timeline;
  const {
    data: savedSearchById,
    isFetching,
    status: savedSearchByIdStatus
  } = (0, _reactQuery.useQuery)({
    queryKey: ['savedSearchById', savedSearchId !== null && savedSearchId !== void 0 ? savedSearchId : ''],
    queryFn: () => savedSearchId ? savedSearchService.get(savedSearchId) : Promise.resolve(null)
  });
  const getCombinedDiscoverSavedSearchState = (0, _react.useCallback)(() => {
    var _discoverStateContain, _discoverStateContain2, _discoverStateContain3, _discoverStateContain4, _discoverStateContain5, _discoverStateContain6;
    if (!discoverSavedSearchState) return;
    return {
      ...((_discoverStateContain = (_discoverStateContain2 = discoverStateContainer.current) === null || _discoverStateContain2 === void 0 ? void 0 : _discoverStateContain2.savedSearchState.getState()) !== null && _discoverStateContain !== void 0 ? _discoverStateContain : discoverSavedSearchState),
      timeRange: discoverDataService.query.timefilter.timefilter.getTime(),
      refreshInterval: (_discoverStateContain3 = discoverStateContainer.current) === null || _discoverStateContain3 === void 0 ? void 0 : (_discoverStateContain4 = _discoverStateContain3.globalState.get()) === null || _discoverStateContain4 === void 0 ? void 0 : _discoverStateContain4.refreshInterval,
      breakdownField: (_discoverStateContain5 = discoverStateContainer.current) === null || _discoverStateContain5 === void 0 ? void 0 : _discoverStateContain5.appState.getState().breakdownField,
      rowsPerPage: (_discoverStateContain6 = discoverStateContainer.current) === null || _discoverStateContain6 === void 0 ? void 0 : _discoverStateContain6.appState.getState().rowsPerPage,
      title: (0, _translations.GET_TIMELINE_DISCOVER_SAVED_SEARCH_TITLE)(title),
      description
    };
  }, [discoverSavedSearchState, discoverStateContainer, discoverDataService.query.timefilter.timefilter, title, description]);
  const combinedDiscoverSavedSearchStateRef = (0, _react.useRef)();
  (0, _react.useEffect)(() => {
    if (isFetching) return;
    if (savedSearchByIdStatus === 'error' && savedSearchId) {
      // when a timeline json is uploaded with a saved search Id that not longer
      // exists, we need to reset the saved search Id in the timeline and remove th saved search
      dispatch((0, _actions.updateSavedSearchId)({
        id: timelineId,
        savedSearchId: null
      }));
      return;
    }
    if (!savedObjectId) return;
    if (!status || status === 'draft') return;
    const latestState = getCombinedDiscoverSavedSearchState();
    const index = latestState === null || latestState === void 0 ? void 0 : latestState.searchSource.getField('index');
    /* when a new timeline is loaded, a new discover instance is loaded which first emits
     * discover's initial state which is then updated in the saved search. We want to avoid that.*/
    if (!index) return;
    if (!latestState || combinedDiscoverSavedSearchStateRef.current === latestState) return;
    if ((0, _lodash.isEqualWith)(latestState, savedSearchById, _utils.savedSearchComparator)) return;
    updateSavedSearch(latestState, timelineId, function onUpdate() {
      combinedDiscoverSavedSearchStateRef.current = latestState;
    });
  }, [getCombinedDiscoverSavedSearchState, savedSearchById, updateSavedSearch, activeTab, status, discoverTimerange, savedObjectId, isFetching, timelineId, dispatch, savedSearchId, savedSearchByIdStatus]);
  (0, _react.useEffect)(() => {
    if (!dataViewId) return;
    dataViewService.get(dataViewId).then(setDataView);
  }, [dataViewId, dataViewService]);
  (0, _react.useEffect)(() => {
    const unSubscribeAll = () => {
      [discoverAppStateSubscription.current, discoverInternalStateSubscription.current, discoverSavedSearchStateSubscription.current, discoverTimerangeSubscription.current].forEach(sub => {
        if (sub) sub.unsubscribe();
      });
    };
    return unSubscribeAll;
  }, [discoverStateContainer]);
  const initialDiscoverCustomizationCallback = (0, _react.useCallback)(async ({
    stateContainer
  }) => {
    var _ref, _savedSearchAppState, _savedSearchAppState$, _savedSearchAppState2, _savedSearchAppState3, _savedSearchAppState4, _stateContainer$appSt, _stateContainer$appSt2;
    setDiscoverStateContainer(stateContainer);
    let savedSearchAppState;
    if (savedSearchId) {
      try {
        const localSavedSearch = await savedSearchService.get(savedSearchId);
        initializeLocalSavedSearch(localSavedSearch, timelineId);
        savedSearchAppState = getAppStateFromSavedSearch(localSavedSearch);
      } catch (e) {
        // eslint-disable-next-line no-console
        console.error('Stale Saved search Id which no longer exists', e);
      }
    }
    const finalAppState = (_ref = ((_savedSearchAppState = savedSearchAppState) === null || _savedSearchAppState === void 0 ? void 0 : (_savedSearchAppState$ = _savedSearchAppState.appState) === null || _savedSearchAppState$ === void 0 ? void 0 : _savedSearchAppState$.query) && 'esql' in ((_savedSearchAppState2 = savedSearchAppState) === null || _savedSearchAppState2 === void 0 ? void 0 : (_savedSearchAppState3 = _savedSearchAppState2.appState) === null || _savedSearchAppState3 === void 0 ? void 0 : _savedSearchAppState3.query) && ((_savedSearchAppState4 = savedSearchAppState) === null || _savedSearchAppState4 === void 0 ? void 0 : _savedSearchAppState4.appState) || discoverAppState) !== null && _ref !== void 0 ? _ref : defaultDiscoverAppState;
    const hasESQLUrlState = (_stateContainer$appSt = stateContainer.appState.getState()) === null || _stateContainer$appSt === void 0 ? void 0 : (_stateContainer$appSt2 = _stateContainer$appSt.query) === null || _stateContainer$appSt2 === void 0 ? void 0 : _stateContainer$appSt2.esql;
    if (stateContainer.appState.isEmptyURL() || !hasESQLUrlState) {
      var _savedSearchAppState5;
      if ((_savedSearchAppState5 = savedSearchAppState) !== null && _savedSearchAppState5 !== void 0 && _savedSearchAppState5.savedSearch.timeRange) {
        var _savedSearchAppState6;
        stateContainer.globalState.set({
          ...stateContainer.globalState.get(),
          time: (_savedSearchAppState6 = savedSearchAppState) === null || _savedSearchAppState6 === void 0 ? void 0 : _savedSearchAppState6.savedSearch.timeRange
        });
      }
      stateContainer.appState.set(finalAppState);
      await stateContainer.appState.replaceUrlState(finalAppState);
    }
    const unsubscribeState = stateContainer.appState.state$.subscribe({
      next: setDiscoverAppState
    });
    const internalStateSubscription = stateContainer.internalState.state$.subscribe({
      next: setDiscoverInternalState
    });
    const savedSearchStateSub = stateContainer.savedSearchState.getHasChanged$().subscribe({
      next: hasChanged => {
        if (hasChanged) {
          const latestSavedSearchState = stateContainer.savedSearchState.getState();
          setDiscoverSavedSearchState(latestSavedSearchState);
        }
      }
    });
    const timeRangeSub = discoverDataService.query.timefilter.timefilter.getTimeUpdate$().subscribe({
      next: () => {
        setDiscoverTimerange(discoverDataService.query.timefilter.timefilter.getTime());
      }
    });
    discoverAppStateSubscription.current = unsubscribeState;
    discoverInternalStateSubscription.current = internalStateSubscription;
    discoverSavedSearchStateSubscription.current = savedSearchStateSub;
    discoverTimerangeSubscription.current = timeRangeSub;
  }, [discoverAppState, setDiscoverSavedSearchState, setDiscoverInternalState, setDiscoverAppState, setDiscoverStateContainer, getAppStateFromSavedSearch, discoverDataService.query.timefilter.timefilter, savedSearchId, savedSearchService, defaultDiscoverAppState, timelineId, initializeLocalSavedSearch]);
  const customizationsCallbacks = (0, _react.useMemo)(() => [initialDiscoverCustomizationCallback, ...discoverCustomizationCallbacks], [initialDiscoverCustomizationCallback, discoverCustomizationCallbacks]);
  const services = (0, _react.useMemo)(() => ({
    data: discoverDataService,
    filterManager: discoverDataService.query.filterManager,
    timefilter: discoverDataService.query.timefilter.timefilter
  }), [discoverDataService]);
  const DiscoverContainer = discover.DiscoverContainer;
  const isLoading = Boolean(!dataView);
  return /*#__PURE__*/_react.default.createElement(_styles.EmbeddedDiscoverContainer, {
    "data-test-subj": "timeline-embedded-discover"
  }, /*#__PURE__*/_react.default.createElement(HideSearchSessionIndicatorBreadcrumbIcon, null), /*#__PURE__*/_react.default.createElement(_styles.TimelineESQLGlobalStyles, null), /*#__PURE__*/_react.default.createElement(DiscoverContainer, {
    overrideServices: services,
    scopedHistory: history,
    customizationCallbacks: customizationsCallbacks,
    isLoading: isLoading
  }));
};

// eslint-disable-next-line import/no-default-export
exports.DiscoverTabContent = DiscoverTabContent;
var _default = exports.default = DiscoverTabContent;