"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EqlTabContentComponent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _fastDeepEqual = _interopRequireDefault(require("fast-deep-equal"));
var _reactReversePortal = require("react-reverse-portal");
var _unifiedDataTable = require("@kbn/unified-data-table");
var _constants = require("../../../../../common/store/inputs/constants");
var _store = require("../../../../store");
var _containers = require("../../../../containers");
var _default_headers = require("../../body/column_headers/default_headers");
var _body = require("../../body");
var _footer = require("../../footer");
var _helpers = require("../../helpers");
var _refetch_timeline = require("../../refetch_timeline");
var _timeline = require("../../../../../../common/types/timeline");
var _default_config = require("../../../../../detections/components/alerts_table/default_config");
var _exit_full_screen = require("../../../../../common/components/exit_full_screen");
var _super_date_picker = require("../../../../../common/components/super_date_picker");
var _event_details_width_context = require("../../../../../common/components/events_viewer/event_details_width_context");
var _store2 = require("../../../../../common/store");
var _model = require("../../../../../common/store/sourcerer/model");
var _defaults = require("../../../../store/defaults");
var _sourcerer = require("../../../../../common/containers/sourcerer");
var _use_timeline_events_count = require("../../../../../common/hooks/use_timeline_events_count");
var _date_picker_lock = require("../../date_picker_lock");
var _use_full_screen = require("../../../../../common/containers/use_full_screen");
var _side_panel = require("../../../side_panel");
var _eql = require("../../query_bar/eql");
var _control_columns = require("../../body/control_columns");
var _sourcerer2 = require("../../../../../common/components/sourcerer");
var _use_license = require("../../../../../common/hooks/use_license");
var _header_actions = require("../../../../../common/components/header_actions/header_actions");
var _layout = require("../shared/layout");
var _utils = require("../shared/utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NO_SORTING = [];
const trailingControlColumns = []; // stable reference

const EqlTabContentComponent = ({
  activeTab,
  columns,
  end,
  eqlOptions,
  expandedDetail,
  timelineId,
  isLive,
  itemsPerPage,
  itemsPerPageOptions,
  onEventClosed,
  renderCellValue,
  rowRenderers,
  showExpandedDetails,
  start,
  timerangeKind
}) => {
  var _pageInfo$activePage;
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    query: eqlQuery = '',
    ...restEqlOption
  } = eqlOptions;
  const {
    portalNode: eqlEventsCountPortalNode
  } = (0, _use_timeline_events_count.useEqlEventsCountPortal)();
  const {
    setTimelineFullScreen,
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  const {
    browserFields,
    dataViewId,
    loading: loadingSourcerer,
    runtimeMappings,
    selectedPatterns
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const isEnterprisePlus = (0, _use_license.useLicense)().isEnterprise();
  const ACTION_BUTTON_COUNT = isEnterprisePlus ? 6 : 5;
  const isBlankTimeline = (0, _fp.isEmpty)(eqlQuery);
  const canQueryTimeline = () => loadingSourcerer != null && !loadingSourcerer && !(0, _fp.isEmpty)(start) && !(0, _fp.isEmpty)(end) && !isBlankTimeline;
  const getTimelineQueryFields = () => {
    const columnsHeader = (0, _fp.isEmpty)(columns) ? _default_headers.defaultHeaders : columns;
    const columnFields = columnsHeader.map(c => c.id);
    return [...columnFields, ..._default_config.requiredFieldsForActions];
  };
  const [queryLoadingState, {
    events,
    inspect,
    totalCount,
    pageInfo,
    loadPage,
    refreshedAt,
    refetch
  }] = (0, _containers.useTimelineEvents)({
    dataViewId,
    endDate: end,
    eqlOptions: restEqlOption,
    fields: getTimelineQueryFields(),
    filterQuery: eqlQuery !== null && eqlQuery !== void 0 ? eqlQuery : '',
    id: timelineId,
    indexNames: selectedPatterns,
    language: 'eql',
    limit: itemsPerPage,
    runtimeMappings,
    skip: !canQueryTimeline(),
    startDate: start,
    timerangeKind
  });
  const isQueryLoading = (0, _react.useMemo)(() => queryLoadingState === _unifiedDataTable.DataLoadingState.loading || queryLoadingState === _unifiedDataTable.DataLoadingState.loadingMore, [queryLoadingState]);
  const handleOnPanelClosed = (0, _react.useCallback)(() => {
    onEventClosed({
      tabType: _timeline.TimelineTabs.eql,
      id: timelineId
    });
  }, [onEventClosed, timelineId]);
  (0, _react.useEffect)(() => {
    dispatch(_store.timelineActions.updateIsLoading({
      id: timelineId,
      isLoading: isQueryLoading || loadingSourcerer
    }));
  }, [loadingSourcerer, timelineId, isQueryLoading, dispatch]);
  const leadingControlColumns = (0, _react.useMemo)(() => (0, _control_columns.getDefaultControlColumn)(ACTION_BUTTON_COUNT).map(x => ({
    ...x,
    headerCellRender: _header_actions.HeaderActions
  })), [ACTION_BUTTON_COUNT]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_reactReversePortal.InPortal, {
    node: eqlEventsCountPortalNode
  }, totalCount >= 0 ? /*#__PURE__*/_react.default.createElement(_layout.EventsCountBadge, null, totalCount) : null), /*#__PURE__*/_react.default.createElement(_refetch_timeline.TimelineRefetch, {
    id: `${timelineId}-${_timeline.TimelineTabs.eql}`,
    inputId: _constants.InputsModelId.timeline,
    inspect: inspect,
    loading: isQueryLoading,
    refetch: refetch
  }), /*#__PURE__*/_react.default.createElement(_layout.FullWidthFlexGroup, null, /*#__PURE__*/_react.default.createElement(_layout.ScrollableFlexItem, {
    grow: 2
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_layout.StyledEuiFlyoutHeader, {
    "data-test-subj": `${activeTab}-tab-flyout-header`,
    hasBorder: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "euiScrollBar",
    alignItems: "flexStart",
    gutterSize: "s",
    "data-test-subj": "timeline-date-picker-container",
    responsive: false
  }, timelineFullScreen && setTimelineFullScreen != null && /*#__PURE__*/_react.default.createElement(_exit_full_screen.ExitFullScreen, {
    fullScreen: timelineFullScreen,
    setFullScreen: setTimelineFullScreen
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, activeTab === _timeline.TimelineTabs.eql && /*#__PURE__*/_react.default.createElement(_sourcerer2.Sourcerer, {
    scope: _model.SourcererScopeName.timeline
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_super_date_picker.SuperDatePicker, {
    width: "auto",
    id: _constants.InputsModelId.timeline,
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_date_picker_lock.TimelineDatePickerLock, null))))), /*#__PURE__*/_react.default.createElement(_layout.TabHeaderContainer, {
    "data-test-subj": "timelineHeader"
  }, /*#__PURE__*/_react.default.createElement(_eql.EqlQueryBarTimeline, {
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_event_details_width_context.EventDetailsWidthProvider, null, /*#__PURE__*/_react.default.createElement(_layout.StyledEuiFlyoutBody, {
    "data-test-subj": `${_timeline.TimelineTabs.eql}-tab-flyout-body`,
    className: "timeline-flyout-body"
  }, /*#__PURE__*/_react.default.createElement(_body.StatefulBody, {
    activePage: pageInfo.activePage,
    browserFields: browserFields,
    data: isBlankTimeline ? _utils.EMPTY_EVENTS : events,
    id: timelineId,
    refetch: refetch,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    sort: NO_SORTING,
    tabType: _timeline.TimelineTabs.eql,
    totalPages: (0, _helpers.calculateTotalPages)({
      itemsCount: totalCount,
      itemsPerPage
    }),
    leadingControlColumns: leadingControlColumns,
    trailingControlColumns: trailingControlColumns
  })), /*#__PURE__*/_react.default.createElement(_layout.StyledEuiFlyoutFooter, {
    "data-test-subj": `${_timeline.TimelineTabs.eql}-tab-flyout-footer`,
    className: "timeline-flyout-footer"
  }, !isBlankTimeline && /*#__PURE__*/_react.default.createElement(_footer.Footer, {
    activePage: (_pageInfo$activePage = pageInfo === null || pageInfo === void 0 ? void 0 : pageInfo.activePage) !== null && _pageInfo$activePage !== void 0 ? _pageInfo$activePage : 0,
    "data-test-subj": "timeline-footer",
    updatedAt: refreshedAt,
    height: _footer.footerHeight,
    id: timelineId,
    isLive: isLive,
    isLoading: isQueryLoading || loadingSourcerer,
    itemsCount: isBlankTimeline ? 0 : events.length,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    onChangePage: loadPage,
    totalCount: isBlankTimeline ? 0 : totalCount
  })))), showExpandedDetails && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_layout.VerticalRule, null), /*#__PURE__*/_react.default.createElement(_layout.ScrollableFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_side_panel.DetailsPanel, {
    browserFields: browserFields,
    runtimeMappings: runtimeMappings,
    tabType: _timeline.TimelineTabs.eql,
    scopeId: timelineId,
    handleOnPanelClosed: handleOnPanelClosed
  })))));
};
exports.EqlTabContentComponent = EqlTabContentComponent;
const makeMapStateToProps = () => {
  const getTimeline = _store.timelineSelectors.getTimelineByIdSelector();
  const getInputsTimeline = _store2.inputsSelectors.getTimelineSelector();
  const mapStateToProps = (state, {
    timelineId
  }) => {
    var _getTimeline, _expandedDetail$Timel;
    const timeline = (_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults;
    const input = getInputsTimeline(state);
    const {
      activeTab,
      columns,
      eqlOptions,
      expandedDetail,
      itemsPerPage,
      itemsPerPageOptions
    } = timeline;
    return {
      activeTab,
      columns,
      eqlOptions,
      end: input.timerange.to,
      expandedDetail,
      timelineId,
      isLive: input.policy.kind === 'interval',
      itemsPerPage,
      itemsPerPageOptions,
      showExpandedDetails: !!expandedDetail[_timeline.TimelineTabs.eql] && !!((_expandedDetail$Timel = expandedDetail[_timeline.TimelineTabs.eql]) !== null && _expandedDetail$Timel !== void 0 && _expandedDetail$Timel.panelView),
      start: input.timerange.from,
      timerangeKind: input.timerange.kind
    };
  };
  return mapStateToProps;
};
const mapDispatchToProps = dispatch => ({
  onEventClosed: args => {
    dispatch(_store.timelineActions.toggleDetailPanel(args));
  }
});
const connector = (0, _reactRedux.connect)(makeMapStateToProps, mapDispatchToProps);
const EqlTabContent = exports.default = connector( /*#__PURE__*/_react.default.memo(EqlTabContentComponent, (prevProps, nextProps) => prevProps.activeTab === nextProps.activeTab && (0, _utils.isTimerangeSame)(prevProps, nextProps) && (0, _fastDeepEqual.default)(prevProps.eqlOptions, nextProps.eqlOptions) && prevProps.isLive === nextProps.isLive && prevProps.itemsPerPage === nextProps.itemsPerPage && prevProps.onEventClosed === nextProps.onEventClosed && prevProps.showExpandedDetails === nextProps.showExpandedDetails && prevProps.timelineId === nextProps.timelineId && (0, _fastDeepEqual.default)(prevProps.columns, nextProps.columns) && (0, _fastDeepEqual.default)(prevProps.itemsPerPageOptions, nextProps.itemsPerPageOptions)));

// eslint-disable-next-line import/no-default-export