"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchOrFilter = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var _constants = require("../../../../common/store/inputs/constants");
var _super_date_picker = require("../../../../common/components/super_date_picker");
var _query_bar = require("../query_bar");
var _date_picker_lock = require("../date_picker_lock");
var _model = require("../../../../common/store/sourcerer/model");
var _sourcerer = require("../../../../common/components/sourcerer");
var _translations = require("./translations");
var _step_config = require("../tour/step_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchOrFilterContainer = _styledComponents.default.div`
  overflow-x: auto;
  overflow-y: hidden;
`;
SearchOrFilterContainer.displayName = 'SearchOrFilterContainer';
const ModeFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  user-select: none; // Again, why?
`;
ModeFlexItem.displayName = 'ModeFlexItem';
const SearchOrFilter = exports.SearchOrFilter = /*#__PURE__*/_react.default.memo(({
  dataProviders,
  isRefreshPaused,
  filters,
  filterManager,
  filterQuery,
  from,
  fromStr,
  kqlMode,
  timelineId,
  refreshInterval,
  savedQueryId,
  setFilters,
  setSavedQueryId,
  to,
  toStr,
  updateReduxTime,
  isDataProviderVisible,
  toggleDataProviderVisibility,
  timelineType
}) => {
  const isDataProviderEmpty = (0, _react.useMemo)(() => (dataProviders === null || dataProviders === void 0 ? void 0 : dataProviders.length) === 0, [dataProviders]);
  const dataProviderIconTooltipContent = (0, _react.useMemo)(() => {
    if (isDataProviderVisible) {
      return _translations.DATA_PROVIDER_VISIBLE;
    }
    if (isDataProviderEmpty) {
      return _translations.DATA_PROVIDER_HIDDEN_EMPTY;
    }
    return _translations.DATA_PROVIDER_HIDDEN_POPULATED;
  }, [isDataProviderEmpty, isDataProviderVisible]);
  const buttonColor = (0, _react.useMemo)(() => isDataProviderEmpty || isDataProviderVisible ? 'primary' : 'warning', [isDataProviderEmpty, isDataProviderVisible]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(SearchOrFilterContainer, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "timeline-search-or-filter",
    gutterSize: "xs",
    alignItems: "flexStart",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    id: _step_config.TIMELINE_TOUR_CONFIG_ANCHORS.DATA_VIEW
  }, /*#__PURE__*/_react.default.createElement(_sourcerer.Sourcerer, {
    scope: _model.SourcererScopeName.timeline
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "timeline-search-or-filter-search-container",
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_query_bar.QueryBarTimeline, {
    dataProviders: dataProviders,
    filters: filters,
    filterManager: filterManager,
    filterQuery: filterQuery,
    from: from,
    fromStr: fromStr,
    kqlMode: kqlMode,
    isRefreshPaused: isRefreshPaused,
    refreshInterval: refreshInterval,
    savedQueryId: savedQueryId,
    setFilters: setFilters,
    setSavedQueryId: setSavedQueryId,
    timelineId: timelineId,
    to: to,
    toStr: toStr,
    updateReduxTime: updateReduxTime
  })),
  /*
  DataProvider toggle is not needed in template timeline because
  it is always visible
  */
  timelineType === _timeline.TimelineType.default ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: dataProviderIconTooltipContent
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    id: _step_config.TIMELINE_TOUR_CONFIG_ANCHORS.DATA_PROVIDER,
    color: buttonColor,
    isSelected: isDataProviderVisible,
    iconType: "timeline",
    "data-test-subj": "toggle-data-provider",
    size: "m",
    display: "base",
    "aria-label": dataProviderIconTooltipContent,
    onClick: toggleDataProviderVisibility
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_date_picker_lock.TimelineDatePickerLock, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "timeline-date-picker-container"
  }, /*#__PURE__*/_react.default.createElement(_super_date_picker.SuperDatePicker, {
    width: "auto",
    id: _constants.InputsModelId.timeline,
    timelineId: timelineId,
    disabled: false
  })))));
});
SearchOrFilter.displayName = 'SearchOrFilter';