"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineContext = exports.StatefulTimeline = void 0;
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _public = require("@kbn/timelines-plugin/public");
var _use_experimental_features = require("../../../common/hooks/use_experimental_features");
var _user_privileges = require("../../../common/components/user_privileges");
var _store = require("../../store");
var _defaults = require("../../store/defaults");
var _default_headers = require("./body/column_headers/default_headers");
var _model = require("../../../common/store/sourcerer/model");
var _header = require("../modal/header");
var _timeline = require("../../../../common/api/timeline");
var _use_selector = require("../../../common/hooks/use_selector");
var _helpers = require("./helpers");
var i18n = _interopRequireWildcard(require("./translations"));
var _tabs = require("./tabs");
var _styles = require("./styles");
var _use_full_screen = require("../../../common/containers/use_full_screen");
var _exit_full_screen = require("../../../common/components/exit_full_screen");
var _use_resolve_conflict = require("../../../common/hooks/use_resolve_conflict");
var _store2 = require("../../../common/store");
var _tour = require("./tour");
var _default_headers2 = require("./unified_components/default_headers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TimelineTemplateBadge = _styledComponents.default.div`
  background: ${({
  theme
}) => theme.eui.euiColorVis3_behindText};
  color: #fff;
  padding: 10px 15px;
  font-size: 0.8em;
`;
const TimelineBody = _styledComponents.default.div`
  height: 100%;
  display: flex;
  flex-direction: column;
`;
const TimelineContext = exports.TimelineContext = /*#__PURE__*/(0, _react.createContext)({
  timelineId: null
});
const TimelineSavingProgressComponent = ({
  timelineId
}) => {
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const isSaving = (0, _use_selector.useShallowEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).isSaving;
  });
  return isSaving ? /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "s",
    color: "primary",
    position: "absolute"
  }) : null;
};
const TimelineSavingProgress = /*#__PURE__*/_react.default.memo(TimelineSavingProgressComponent);
const StatefulTimelineComponent = ({
  renderCellValue,
  rowRenderers,
  timelineId,
  openToggleRef
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const unifiedComponentsInTimelineEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('unifiedComponentsInTimelineEnabled');
  const containerElement = (0, _react.useRef)(null);
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const selectedPatternsSourcerer = (0, _reactRedux.useSelector)(state => {
    return _store2.sourcererSelectors.sourcererScopeSelectedPatterns(state, _model.SourcererScopeName.timeline);
  });
  const selectedDataViewIdSourcerer = (0, _reactRedux.useSelector)(state => {
    return _store2.sourcererSelectors.sourcererScopeSelectedDataViewId(state, _model.SourcererScopeName.timeline);
  });
  const {
    dataViewId: selectedDataViewIdTimeline,
    indexNames: selectedPatternsTimeline,
    graphEventId,
    savedObjectId,
    timelineType,
    description,
    sessionViewConfig,
    initialized,
    show: isOpen,
    isLoading,
    activeTab
  } = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline2;
    return (0, _fp.pick)(['indexNames', 'dataViewId', 'graphEventId', 'savedObjectId', 'timelineType', 'description', 'sessionViewConfig', 'initialized', 'show', 'isLoading', 'activeTab'], (_getTimeline2 = getTimeline(state, timelineId)) !== null && _getTimeline2 !== void 0 ? _getTimeline2 : _defaults.timelineDefaults);
  });
  const {
    kibanaSecuritySolutionsPrivileges: {
      crud: canEditTimeline
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    timelineFullScreen
  } = (0, _use_full_screen.useTimelineFullScreen)();
  (0, _react.useEffect)(() => {
    if (!savedObjectId && !initialized) {
      dispatch(_store.timelineActions.createTimeline({
        id: timelineId,
        columns: unifiedComponentsInTimelineEnabled ? _default_headers2.defaultUdtHeaders : _default_headers.defaultHeaders,
        dataViewId: selectedDataViewIdSourcerer,
        indexNames: selectedPatternsSourcerer,
        show: false
      }));
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  const onSourcererChange = (0, _react.useCallback)(() => {
    if (
    // timeline not initialized, so this must be initial state and not user change
    !savedObjectId || selectedDataViewIdSourcerer == null ||
    // initial state will get set on create
    selectedDataViewIdTimeline === null && selectedPatternsTimeline.length === 0 ||
    // don't update if no change
    selectedDataViewIdTimeline === selectedDataViewIdSourcerer && selectedPatternsTimeline.sort().join() === selectedPatternsSourcerer.sort().join()) {
      return;
    }
    dispatch(_store.timelineActions.updateDataView({
      dataViewId: selectedDataViewIdSourcerer,
      id: timelineId,
      indexNames: selectedPatternsSourcerer
    }));
  }, [dispatch, savedObjectId, selectedDataViewIdSourcerer, selectedDataViewIdTimeline, selectedPatternsSourcerer, selectedPatternsTimeline, timelineId]);
  (0, _react.useEffect)(() => {
    onSourcererChange();
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [selectedDataViewIdSourcerer, selectedPatternsSourcerer]);
  const onSkipFocusBeforeEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur;
    const exitFullScreenButton = (_containerElement$cur = containerElement.current) === null || _containerElement$cur === void 0 ? void 0 : _containerElement$cur.querySelector(_exit_full_screen.EXIT_FULL_SCREEN_CLASS_NAME);
    if (exitFullScreenButton != null) {
      exitFullScreenButton.focus();
    } else {
      var _containerElement$cur2, _containerElement$cur3;
      (_containerElement$cur2 = containerElement.current) === null || _containerElement$cur2 === void 0 ? void 0 : (_containerElement$cur3 = _containerElement$cur2.querySelector('.globalFilterBar__addButton')) === null || _containerElement$cur3 === void 0 ? void 0 : _containerElement$cur3.focus();
    }
  }, [containerElement]);
  const onSkipFocusAfterEventsTable = (0, _react.useCallback)(() => {
    var _containerElement$cur4, _containerElement$cur5;
    (_containerElement$cur4 = containerElement.current) === null || _containerElement$cur4 === void 0 ? void 0 : (_containerElement$cur5 = _containerElement$cur4.querySelector(`.${_helpers.EVENTS_COUNT_BUTTON_CLASS_NAME}`)) === null || _containerElement$cur5 === void 0 ? void 0 : _containerElement$cur5.focus();
  }, [containerElement]);
  const onKeyDown = (0, _react.useCallback)(keyboardEvent => {
    if ((0, _public.isTab)(keyboardEvent)) {
      (0, _helpers.onTimelineTabKeyPressed)({
        containerElement: containerElement.current,
        keyboardEvent,
        onSkipFocusBeforeEventsTable,
        onSkipFocusAfterEventsTable
      });
    }
  }, [containerElement, onSkipFocusBeforeEventsTable, onSkipFocusAfterEventsTable]);
  const timelineContext = (0, _react.useMemo)(() => ({
    timelineId
  }), [timelineId]);
  const resolveConflictComponent = (0, _use_resolve_conflict.useResolveConflict)();
  const showTimelineTour = isOpen && !isLoading && canEditTimeline;
  const handleSwitchToTab = (0, _react.useCallback)(tab => {
    dispatch(_store.timelineActions.setActiveTabTimeline({
      id: timelineId,
      activeTab: tab
    }));
  }, [timelineId, dispatch]);
  return /*#__PURE__*/_react.default.createElement(TimelineContext.Provider, {
    value: timelineContext
  }, /*#__PURE__*/_react.default.createElement(_styles.TimelineContainer, {
    "data-test-subj": "timeline",
    "data-timeline-id": timelineId,
    onKeyDown: onKeyDown,
    ref: containerElement
  }, /*#__PURE__*/_react.default.createElement(TimelineSavingProgress, {
    timelineId: timelineId
  }), /*#__PURE__*/_react.default.createElement(TimelineBody, {
    "data-test-subj": "timeline-body"
  }, timelineType === _timeline.TimelineType.template && /*#__PURE__*/_react.default.createElement(TimelineTemplateBadge, {
    className: "timeline-template-badge"
  }, i18n.TIMELINE_TEMPLATE), resolveConflictComponent, /*#__PURE__*/_react.default.createElement(_styles.HideShowContainer, {
    $isVisible: !timelineFullScreen,
    "data-test-subj": "timeline-hide-show-container"
  }, /*#__PURE__*/_react.default.createElement(_header.TimelineModalHeader, {
    timelineId: timelineId,
    openToggleRef: openToggleRef
  })), /*#__PURE__*/_react.default.createElement(_tabs.TabsContent, {
    graphEventId: graphEventId,
    sessionViewConfig: sessionViewConfig,
    renderCellValue: renderCellValue,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    timelineType: timelineType,
    timelineDescription: description,
    timelineFullScreen: timelineFullScreen
  }))), showTimelineTour ? /*#__PURE__*/_react.default.createElement(_tour.TimelineTour, {
    activeTab: activeTab,
    switchToTab: handleSwitchToTab,
    timelineType: timelineType
  }) : null);
};
StatefulTimelineComponent.displayName = 'StatefulTimelineComponent';
const StatefulTimeline = exports.StatefulTimeline = /*#__PURE__*/_react.default.memo(StatefulTimelineComponent);