"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCompactFooter = exports.FixedWidthLastUpdatedContainer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _event_details_width_context = require("../../../../common/components/events_viewer/event_details_width_context");
var _kibana = require("../../../../common/lib/kibana");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isCompactFooter = width => width < 600;
exports.isCompactFooter = isCompactFooter;
const FixedWidthLastUpdatedContainer = exports.FixedWidthLastUpdatedContainer = /*#__PURE__*/_react.default.memo(({
  updatedAt
}) => {
  const {
    timelines
  } = (0, _kibana.useKibana)().services;
  const width = (0, _event_details_width_context.useEventDetailsWidthContext)();
  const compact = (0, _react.useMemo)(() => isCompactFooter(width), [width]);
  return updatedAt > 0 ? /*#__PURE__*/_react.default.createElement(FixedWidthLastUpdated, {
    "data-test-subj": "fixed-width-last-updated",
    compact: compact
  }, timelines.getLastUpdated({
    updatedAt,
    compact
  })) : null;
});
FixedWidthLastUpdatedContainer.displayName = 'FixedWidthLastUpdatedContainer';
const FixedWidthLastUpdated = _styledComponents.default.span`
  width: ${({
  compact
}) => !compact ? 200 : 25}px;
  text-overflow: ellipsis;
  text-align: end;
  overflow: hidden;
`;
FixedWidthLastUpdated.displayName = 'FixedWidthLastUpdated';