"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Provider = void 0;
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _data_provider = require("./data_provider");
var _provider_item_badge = require("./provider_item_badge");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const Provider = exports.Provider = /*#__PURE__*/_react.default.memo(({
  dataProvider
}) => {
  var _dataProvider$queryMa;
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react.useState)(false);
  return /*#__PURE__*/_react.default.createElement(_provider_item_badge.ProviderItemBadge, {
    deleteProvider: _fp.noop,
    field: dataProvider.queryMatch.displayField || dataProvider.queryMatch.field,
    kqlQuery: dataProvider.kqlQuery,
    isEnabled: dataProvider.enabled,
    isExcluded: dataProvider.excluded,
    providerId: dataProvider.id,
    isPopoverOpen: isPopoverOpen,
    setIsPopoverOpen: setIsPopoverOpen,
    toggleExcludedProvider: _fp.noop,
    toggleEnabledProvider: _fp.noop,
    toggleTypeProvider: _fp.noop,
    displayValue: String((_dataProvider$queryMa = dataProvider.queryMatch.displayValue) !== null && _dataProvider$queryMa !== void 0 ? _dataProvider$queryMa : dataProvider.queryMatch.value),
    val: dataProvider.queryMatch.value,
    operator: dataProvider.queryMatch.operator || _data_provider.IS_OPERATOR,
    type: dataProvider.type || _data_provider.DataProviderType.default
  });
});
Provider.displayName = 'Provider';