"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataProviders = void 0;
var _polished = require("polished");
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _uuid = require("uuid");
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _eui = require("@elastic/eui");
var _model = require("../../../../common/store/sourcerer/model");
var _sourcerer = require("../../../../common/containers/sourcerer");
var _use_selector = require("../../../../common/hooks/use_selector");
var _droppable_wrapper = require("../../../../common/components/drag_and_drop/droppable_wrapper");
var _helpers = require("../../../../common/components/drag_and_drop/helpers");
var _empty = require("./empty");
var _providers = require("./providers");
var _store = require("../../../store");
var _defaults = require("../../../store/defaults");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers2 = require("../search_or_filter/helpers");
var _actions = require("../../../store/actions");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DropTargetDataProvidersContainer = _styledComponents.default.div`
  position: relative;

  .${_securitysolutionTGrid.IS_DRAGGING_CLASS_NAME} & .drop-target-data-providers {
    background: ${({
  theme
}) => (0, _polished.rgba)(theme.eui.euiColorSuccess, 0.1)};
    border: 0.2rem dashed ${({
  theme
}) => theme.eui.euiColorSuccess};

    & .timeline-drop-area-empty__text {
      color: ${({
  theme
}) => theme.eui.euiColorSuccess};
    }

    & .euiFormHelpText {
      color: ${({
  theme
}) => theme.eui.euiColorSuccess};
    }
  }
`;
const DropTargetDataProviders = _styledComponents.default.div`
  display: flex;
  flex-direction: column;
  justify-content: flex-start;
  position: relative;
  border: 0.2rem dashed ${({
  theme
}) => theme.eui.euiColorMediumShade};
  border-radius: 5px;
  padding: ${({
  theme
}) => theme.eui.euiSizeS} 0;
  margin: 0px 0 0px 0;
  max-height: 33vh;
  min-height: 100px;
  overflow: auto;
  resize: vertical;
  background-color: ${({
  theme
}) => theme.eui.euiFormBackgroundColor};
`;
DropTargetDataProviders.displayName = 'DropTargetDataProviders';
const getDroppableId = id => `${_helpers.droppableTimelineProvidersPrefix}${id}${(0, _uuid.v4)()}`;

/**
 * Renders the data providers section of the timeline.
 *
 * The data providers section is a drop target where users
 * can drag-and drop new data providers into the timeline.
 *
 * It renders an interactive card representation of the
 * data providers. It also provides uniform
 * UI controls for the following actions:
 * 1) removing a data provider
 * 2) temporarily disabling a data provider
 * 3) applying boolean negation to the data provider
 *
 * Given an empty collection of DataProvider[], it prompts
 * the user to drop anything with a facet count into
 * the data pro section.
 */

const timelineSelectModeItemsClassName = 'timelineSelectModeItemsClassName';
const searchOrFilterPopoverClassName = 'searchOrFilterPopover';
const searchOrFilterPopoverWidth = 350;
const popoverProps = {
  className: searchOrFilterPopoverClassName,
  panelClassName: searchOrFilterPopoverClassName,
  panelMinWidth: searchOrFilterPopoverWidth
};
const CustomTooltipDiv = _styledComponents.default.div`
  position: relative;
`;
const DataProviders = exports.DataProviders = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    browserFields
  } = (0, _sourcerer.useSourcererDataView)(_model.SourcererScopeName.timeline);
  const getTimeline = (0, _react.useMemo)(() => _store.timelineSelectors.getTimelineByIdSelector(), []);
  const isLoading = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline;
    return ((_getTimeline = getTimeline(state, timelineId)) !== null && _getTimeline !== void 0 ? _getTimeline : _defaults.timelineDefaults).isLoading;
  });
  const dataProviders = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline2;
    return ((_getTimeline2 = getTimeline(state, timelineId)) !== null && _getTimeline2 !== void 0 ? _getTimeline2 : _defaults.timelineDefaults).dataProviders;
  });
  const droppableId = (0, _react.useMemo)(() => getDroppableId(timelineId), [timelineId]);
  const kqlMode = (0, _use_selector.useDeepEqualSelector)(state => {
    var _getTimeline3;
    return ((_getTimeline3 = getTimeline(state, timelineId)) !== null && _getTimeline3 !== void 0 ? _getTimeline3 : _defaults.timelineDefaults).kqlMode;
  });
  const handleChange = (0, _react.useCallback)(mode => {
    dispatch((0, _actions.updateKqlMode)({
      id: timelineId,
      kqlMode: mode
    }));
  }, [timelineId, dispatch]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(DropTargetDataProvidersContainer, {
    "aria-label": i18n.QUERY_AREA_ARIA_LABEL,
    className: "drop-target-data-providers-container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: 'row',
    justifyContent: "flexStart",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(CustomTooltipDiv, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    className: "timeline-select-search-filter-tooltip",
    content: i18n.FILTER_OR_SEARCH_WITH_KQL
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    className: "timeline-select-search-or-filter",
    "data-test-subj": "timeline-select-search-or-filter",
    hasDividers: true,
    itemLayoutAlign: "top",
    itemClassName: timelineSelectModeItemsClassName,
    onChange: handleChange,
    options: _helpers2.options,
    popoverProps: popoverProps,
    valueOfSelected: kqlMode
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(DropTargetDataProviders, {
    className: "drop-target-data-providers",
    "data-test-subj": "dataProviders"
  }, dataProviders != null && dataProviders.length ? /*#__PURE__*/_react.default.createElement(_providers.Providers, {
    browserFields: browserFields,
    timelineId: timelineId,
    dataProviders: dataProviders
  }) : /*#__PURE__*/_react.default.createElement(_droppable_wrapper.DroppableWrapper, {
    isDropDisabled: isLoading,
    droppableId: droppableId
  }, /*#__PURE__*/_react.default.createElement(_empty.Empty, {
    browserFields: browserFields,
    timelineId: timelineId
  })))))));
});
DataProviders.displayName = 'DataProviders';