"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UnifiedTimelineBody = void 0;
var _react = _interopRequireWildcard(require("react"));
var _domDragDrop = require("@kbn/dom-drag-drop");
var _lodash = require("lodash");
var _styles = require("../unified_components/styles");
var _unified_components = require("../unified_components");
var _default_headers = require("../unified_components/default_headers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UnifiedTimelineBody = props => {
  const {
    header,
    pageInfo,
    columns,
    rowRenderers,
    timelineId,
    itemsPerPage,
    itemsPerPageOptions,
    sort,
    events,
    refetch,
    dataLoadingState,
    totalCount,
    onEventClosed,
    expandedDetail,
    showExpandedDetails,
    onChangePage,
    activeTab,
    updatedAt
  } = props;
  const [pageRows, setPageRows] = (0, _react.useState)([]);
  const rows = (0, _react.useMemo)(() => pageRows.flat(), [pageRows]);
  (0, _react.useEffect)(() => {
    setPageRows(currentPageRows => {
      var _currentPageRows$page;
      if (pageInfo.activePage !== 0 && (_currentPageRows$page = currentPageRows[pageInfo.activePage]) !== null && _currentPageRows$page !== void 0 && _currentPageRows$page.length) {
        return currentPageRows;
      }
      const newPageRows = pageInfo.activePage === 0 ? [] : [...currentPageRows];
      newPageRows[pageInfo.activePage] = events;
      return newPageRows;
    });
  }, [events, pageInfo.activePage]);
  const columnsHeader = (0, _react.useMemo)(() => {
    return (0, _lodash.isEmpty)(columns) ? _default_headers.defaultUdtHeaders : columns;
  }, [columns]);
  return /*#__PURE__*/_react.default.createElement(_styles.StyledTableFlexGroup, {
    direction: "column",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_styles.StyledTableFlexItem, {
    grow: false
  }, header), /*#__PURE__*/_react.default.createElement(_styles.StyledTableFlexItem, {
    className: "unifiedTimelineBody",
    "data-test-subj": "unifiedTimelineBody"
  }, /*#__PURE__*/_react.default.createElement(_domDragDrop.RootDragDropProvider, null, /*#__PURE__*/_react.default.createElement(_unified_components.UnifiedTimeline, {
    columns: columnsHeader,
    rowRenderers: rowRenderers,
    timelineId: timelineId,
    itemsPerPage: itemsPerPage,
    itemsPerPageOptions: itemsPerPageOptions,
    sort: sort,
    events: rows,
    refetch: refetch,
    dataLoadingState: dataLoadingState,
    totalCount: totalCount,
    onEventClosed: onEventClosed,
    expandedDetail: expandedDetail,
    showExpandedDetails: showExpandedDetails,
    onChangePage: onChangePage,
    activeTab: activeTab,
    updatedAt: updatedAt,
    isTextBasedQuery: false
  }))));
};
exports.UnifiedTimelineBody = UnifiedTimelineBody;