"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDirection = exports.SortIndicator = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var i18n = _interopRequireWildcard(require("../translations"));
var _sort_number = require("./sort_number");
var _search_strategy = require("../../../../../../common/search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var SortDirectionIndicatorEnum = /*#__PURE__*/function (SortDirectionIndicatorEnum) {
  SortDirectionIndicatorEnum["SORT_UP"] = "sortUp";
  SortDirectionIndicatorEnum["SORT_DOWN"] = "sortDown";
  return SortDirectionIndicatorEnum;
}(SortDirectionIndicatorEnum || {});
/** Returns the symbol that corresponds to the specified `SortDirection` */
const getDirection = sortDirection => {
  switch (sortDirection) {
    case _search_strategy.Direction.asc:
      return SortDirectionIndicatorEnum.SORT_UP;
    case _search_strategy.Direction.desc:
      return SortDirectionIndicatorEnum.SORT_DOWN;
    case 'none':
      return undefined;
    default:
      throw new Error('Unhandled sort direction');
  }
};
exports.getDirection = getDirection;
/** Renders a sort indicator */
const SortIndicator = exports.SortIndicator = /*#__PURE__*/_react.default.memo(({
  sortDirection,
  sortNumber
}) => {
  const direction = getDirection(sortDirection);
  if (direction != null) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: direction === SortDirectionIndicatorEnum.SORT_UP ? i18n.SORTED_ASCENDING : i18n.SORTED_DESCENDING,
      "data-test-subj": "sort-indicator-tooltip"
    }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "sortIndicator",
      type: direction
    }), /*#__PURE__*/_react.default.createElement(_sort_number.SortNumber, {
      sortNumber: sortNumber
    })));
  } else {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      "data-test-subj": "sortIndicator",
      type: 'empty'
    });
  }
});
SortIndicator.displayName = 'SortIndicator';