"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DnsRequestEventDetailsLine = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var _helpers = require("../helpers");
var _process_draggable = require("../process_draggable");
var _user_host_working_dir = require("../user_host_working_dir");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DnsRequestEventDetailsLine = exports.DnsRequestEventDetailsLine = /*#__PURE__*/_react.default.memo(({
  contextId,
  dnsQuestionName,
  dnsQuestionType,
  dnsResolvedIp,
  dnsResponseCode,
  eventCode,
  hostName,
  id,
  isDraggable,
  processExecutable,
  processName,
  processPid,
  userDomain,
  userName,
  winlogEventId
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    justifyContent: "center",
    gutterSize: "none",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_user_host_working_dir.UserHostWorkingDir, {
    contextId: contextId,
    eventId: id,
    hostName: hostName,
    isDraggable: isDraggable,
    userDomain: userDomain,
    userName: userName,
    workingDirectory: undefined
  }), !(0, _helpers.isNillEmptyOrNotFinite)(dnsQuestionName) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "asked-for",
    grow: false
  }, i18n.ASKED_FOR), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "dns.question.name",
    isDraggable: isDraggable,
    value: dnsQuestionName,
    isAggregatable: true,
    fieldType: "keyword"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsQuestionType) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "with-question-type",
    grow: false
  }, i18n.WITH_QUESTION_TYPE), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "dns.question.type",
    isDraggable: isDraggable,
    value: dnsQuestionType,
    isAggregatable: true,
    fieldType: "keyword"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsResolvedIp) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "which-resolved-to",
    grow: false
  }, i18n.WHICH_RESOLVED_TO), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "dns.resolved_ip",
    isDraggable: isDraggable,
    value: dnsResolvedIp,
    isAggregatable: true,
    fieldType: "ip"
  }))), !(0, _helpers.isNillEmptyOrNotFinite)(dnsResponseCode) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, '('), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    "data-test-subj": "response-code",
    grow: false
  }, i18n.RESPONSE_CODE), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "dns.response_code",
    isDraggable: isDraggable,
    value: dnsResponseCode,
    isAggregatable: true,
    fieldType: "keyword"
  })), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, ')')), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, i18n.VIA), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_process_draggable.ProcessDraggableWithNonExistentProcess, {
    contextId: contextId,
    endgamePid: undefined,
    endgameProcessName: undefined,
    eventId: id,
    isDraggable: isDraggable,
    processPid: processPid,
    processName: processName,
    processExecutable: processExecutable
  })), (!(0, _helpers.isNillEmptyOrNotFinite)(eventCode) || !(0, _helpers.isNillEmptyOrNotFinite)(winlogEventId)) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _helpers.isNillEmptyOrNotFinite)(eventCode) ? /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    field: "event.code",
    isDraggable: isDraggable,
    value: eventCode,
    isAggregatable: true,
    fieldType: "number"
  })) : /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
    component: "span",
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
    contextId: contextId,
    eventId: id,
    iconType: "logoWindows",
    field: "winlog.event_id",
    isDraggable: isDraggable,
    value: winlogEventId,
    isAggregatable: true,
    fieldType: "keyword"
  })))));
});
DnsRequestEventDetailsLine.displayName = 'DnsRequestEventDetailsLine';