"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DnsRequestEventDetails = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _helpers = require("../helpers");
var _netflow = require("../netflow");
var _dns_request_event_details_line = require("./dns_request_event_details_line");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DnsRequestEventDetails = exports.DnsRequestEventDetails = /*#__PURE__*/_react.default.memo(({
  data,
  contextId,
  isDraggable,
  timelineId
}) => {
  const dnsQuestionName = (0, _fp.get)('dns.question.name[0]', data);
  const dnsQuestionType = (0, _fp.get)('dns.question.type[0]', data);
  const dnsResolvedIp = (0, _fp.get)('dns.resolved_ip[0]', data);
  const dnsResponseCode = (0, _fp.get)('dns.response_code[0]', data);
  const eventCode = (0, _fp.get)('event.code[0]', data);
  const hostName = (0, _fp.get)('host.name[0]', data);
  const id = data._id;
  const processExecutable = (0, _fp.get)('process.executable[0]', data);
  const processName = (0, _fp.get)('process.name[0]', data);
  const processPid = (0, _fp.get)('process.pid[0]', data);
  const userDomain = (0, _fp.get)('user.domain[0]', data);
  const userName = (0, _fp.get)('user.name[0]', data);
  const winlogEventId = (0, _fp.get)('winlog.event_id[0]', data);
  return /*#__PURE__*/_react.default.createElement(_helpers.Details, null, /*#__PURE__*/_react.default.createElement(_dns_request_event_details_line.DnsRequestEventDetailsLine, {
    contextId: contextId,
    dnsQuestionName: dnsQuestionName,
    dnsQuestionType: dnsQuestionType,
    dnsResolvedIp: dnsResolvedIp,
    dnsResponseCode: dnsResponseCode,
    eventCode: eventCode,
    hostName: hostName,
    id: id,
    isDraggable: isDraggable,
    processExecutable: processExecutable,
    processName: processName,
    processPid: processPid,
    userDomain: userDomain,
    userName: userName,
    winlogEventId: winlogEventId
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_netflow.NetflowRenderer, {
    data: data,
    isDraggable: isDraggable,
    timelineId: timelineId
  }));
});
DnsRequestEventDetails.displayName = 'DnsRequestEventDetails';