"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SessionUserHostWorkingDir = void 0;
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../../../common/components/draggables");
var i18n = _interopRequireWildcard(require("./translations"));
var _helpers = require("../helpers");
var _host_working_dir = require("../host_working_dir");
var _primary_secondary_user_info = require("./primary_secondary_user_info");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SessionUserHostWorkingDir = exports.SessionUserHostWorkingDir = /*#__PURE__*/_react.default.memo(({
  eventId,
  contextId,
  hostName,
  userName,
  primary,
  secondary,
  workingDirectory,
  session,
  isDraggable
}) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, i18n.SESSION), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: eventId,
  field: "auditd.session",
  value: session,
  iconType: "number",
  isDraggable: isDraggable,
  isAggregatable: true,
  fieldType: "keyword"
})), /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, /*#__PURE__*/_react.default.createElement(_primary_secondary_user_info.PrimarySecondaryUserInfo, {
  contextId: contextId,
  eventId: eventId,
  userName: userName,
  primary: primary,
  secondary: secondary,
  isDraggable: isDraggable
})), hostName != null && /*#__PURE__*/_react.default.createElement(_helpers.TokensFlexItem, {
  grow: false,
  component: "span"
}, '@'), /*#__PURE__*/_react.default.createElement(_host_working_dir.HostWorkingDir, {
  contextId: contextId,
  eventId: eventId,
  workingDirectory: workingDirectory,
  hostName: hostName,
  isDraggable: isDraggable
})));
SessionUserHostWorkingDir.displayName = 'SessionUserHostWorkingDir';