"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stringifyEvent = exports.omitTypenameAndEmpty = exports.isEventBuildingBlockType = exports.isEvenEqlSequence = exports.getPinTooltip = exports.getPinOnClick = exports.getEventType = exports.getEventIdToDataMapping = exports.eventIsPinned = exports.eventHasNotes = exports.NOTE_CONTENT_CLASS_NAME = void 0;
var _fp = require("lodash/fp");
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const omitTypenameAndEmpty = (k, v) => k !== '__typename' && v != null ? v : undefined;
exports.omitTypenameAndEmpty = omitTypenameAndEmpty;
const stringifyEvent = ecs => JSON.stringify(ecs, omitTypenameAndEmpty, 2);
exports.stringifyEvent = stringifyEvent;
const eventHasNotes = noteIds => !(0, _fp.isEmpty)(noteIds);
exports.eventHasNotes = eventHasNotes;
const getPinTooltip = ({
  isAlert,
  isPinned,
  // eslint-disable-next-line @typescript-eslint/no-shadow
  eventHasNotes,
  timelineType
}) => {
  if (timelineType === _timeline.TimelineType.template) {
    return i18n.DISABLE_PIN(isAlert);
  } else if (isPinned && eventHasNotes) {
    return i18n.PINNED_WITH_NOTES(isAlert);
  } else if (isPinned) {
    return i18n.PINNED(isAlert);
  } else {
    return i18n.UNPINNED(isAlert);
  }
};
exports.getPinTooltip = getPinTooltip;
const eventIsPinned = ({
  eventId,
  pinnedEventIds
}) => pinnedEventIds[eventId] === true;
exports.eventIsPinned = eventIsPinned;
const getPinOnClick = ({
  allowUnpinning,
  eventId,
  onPinEvent,
  onUnPinEvent,
  isEventPinned
}) => {
  if (!allowUnpinning) {
    return;
  }
  if (isEventPinned) {
    onUnPinEvent(eventId);
  } else {
    onPinEvent(eventId);
  }
};

/**
 * Creates mapping of eventID -> fieldData for given fieldsToKeep. Used to store additional field
 * data necessary for custom timeline actions in conjunction with selection state
 * @param timelineData
 * @param eventIds
 * @param fieldsToKeep
 */
exports.getPinOnClick = getPinOnClick;
const getEventIdToDataMapping = (timelineData, eventIds, fieldsToKeep) => timelineData.reduce((acc, v) => {
  const fvm = eventIds.includes(v._id) ? {
    [v._id]: v.data.filter(ti => fieldsToKeep.includes(ti.field))
  } : {};
  return {
    ...acc,
    ...fvm
  };
}, {});
exports.getEventIdToDataMapping = getEventIdToDataMapping;
const isEventBuildingBlockType = event => {
  var _event$kibana, _event$kibana$alert;
  return !(0, _fp.isEmpty)((_event$kibana = event.kibana) === null || _event$kibana === void 0 ? void 0 : (_event$kibana$alert = _event$kibana.alert) === null || _event$kibana$alert === void 0 ? void 0 : _event$kibana$alert.building_block_type);
};
exports.isEventBuildingBlockType = isEventBuildingBlockType;
const isEvenEqlSequence = event => {
  var _event$eql;
  if (!(0, _fp.isEmpty)((_event$eql = event.eql) === null || _event$eql === void 0 ? void 0 : _event$eql.sequenceNumber)) {
    try {
      var _event$eql$sequenceNu, _event$eql2;
      const sequenceNumber = ((_event$eql$sequenceNu = (_event$eql2 = event.eql) === null || _event$eql2 === void 0 ? void 0 : _event$eql2.sequenceNumber) !== null && _event$eql$sequenceNu !== void 0 ? _event$eql$sequenceNu : '').split('-')[0];
      return parseInt(sequenceNumber, 10) % 2 === 0;
    } catch {
      return false;
    }
  }
  return false;
};
/** Return eventType raw or signal or eql */
exports.isEvenEqlSequence = isEvenEqlSequence;
const getEventType = event => {
  var _event$kibana2, _event$kibana2$alert, _event$kibana2$alert$, _event$eql3;
  if (!(0, _fp.isEmpty)((_event$kibana2 = event.kibana) === null || _event$kibana2 === void 0 ? void 0 : (_event$kibana2$alert = _event$kibana2.alert) === null || _event$kibana2$alert === void 0 ? void 0 : (_event$kibana2$alert$ = _event$kibana2$alert.rule) === null || _event$kibana2$alert$ === void 0 ? void 0 : _event$kibana2$alert$.uuid)) {
    return 'signal';
  } else if (!(0, _fp.isEmpty)((_event$eql3 = event.eql) === null || _event$eql3 === void 0 ? void 0 : _event$eql3.parentId)) {
    return 'eql';
  }
  return 'raw';
};
exports.getEventType = getEventType;
const NOTE_CONTENT_CLASS_NAME = exports.NOTE_CONTENT_CLASS_NAME = 'note-content';