"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isFullScreen = exports.DraggableContainer = exports.ColumnHeadersComponent = exports.ColumnHeaders = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _dnd = require("@hello-pangea/dnd");
var _reactRedux = require("react-redux");
var _actions = require("../../../../store/actions");
var _draggable_wrapper = require("../../../../../common/components/drag_and_drop/draggable_wrapper");
var _field_badge = require("../../../../../common/components/draggables/field_badge");
var _helpers = require("../../../../../common/components/drag_and_drop/helpers");
var _styles = require("../../styles");
var _column_header = require("./column_header");
var _model = require("../../../../../common/store/sourcerer/model");
var _fields_browser = require("../../../fields_browser");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DraggableContainer = exports.DraggableContainer = /*#__PURE__*/_react.default.memo(({
  children,
  onMount,
  onUnmount
}) => {
  (0, _react.useEffect)(() => {
    onMount();
    return () => onUnmount();
  }, [onMount, onUnmount]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, children);
});
DraggableContainer.displayName = 'DraggableContainer';
const isFullScreen = ({
  globalFullScreen,
  isActiveTimelines,
  timelineFullScreen
}) => isActiveTimelines && timelineFullScreen || isActiveTimelines === false && globalFullScreen;

/** Renders the timeline header columns */
exports.isFullScreen = isFullScreen;
const ColumnHeadersComponent = ({
  actionsColumnWidth,
  browserFields,
  columnHeaders,
  isEventViewer = false,
  isSelectAllChecked,
  onSelectAll,
  show,
  showEventsSelect,
  showSelectAllCheckbox,
  sort,
  tabType,
  timelineId,
  leadingControlColumns,
  trailingControlColumns
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const [draggingIndex, setDraggingIndex] = (0, _react.useState)(null);
  const fieldEditorActionsRef = (0, _react.useRef)(null);
  (0, _react.useEffect)(() => {
    return () => {
      if (fieldEditorActionsRef.current) {
        // eslint-disable-next-line react-hooks/exhaustive-deps
        fieldEditorActionsRef.current.closeEditor();
      }
    };
  }, []);
  (0, _react.useEffect)(() => {
    if (!show && fieldEditorActionsRef.current) {
      fieldEditorActionsRef.current.closeEditor();
    }
  }, [show]);
  const renderClone = (0, _react.useCallback)((dragProvided, _dragSnapshot, rubric) => {
    const index = rubric.source.index;
    const header = columnHeaders[index];
    const onMount = () => setDraggingIndex(index);
    const onUnmount = () => setDraggingIndex(null);
    return /*#__PURE__*/_react.default.createElement(_styles.EventsTh, (0, _extends2.default)({
      "data-test-subj": "draggable-header"
    }, dragProvided.draggableProps, dragProvided.dragHandleProps, {
      ref: dragProvided.innerRef
    }), /*#__PURE__*/_react.default.createElement(DraggableContainer, {
      onMount: onMount,
      onUnmount: onUnmount
    }, /*#__PURE__*/_react.default.createElement(_draggable_wrapper.DragEffects, null, /*#__PURE__*/_react.default.createElement(_field_badge.DraggableFieldBadge, {
      fieldId: header.id,
      fieldWidth: header.initialWidth
    }))));
  }, [columnHeaders, setDraggingIndex]);
  const ColumnHeaderList = (0, _react.useMemo)(() => columnHeaders.map((header, draggableIndex) => /*#__PURE__*/_react.default.createElement(_column_header.ColumnHeader, {
    key: header.id,
    draggableIndex: draggableIndex,
    timelineId: timelineId,
    header: header,
    isDragging: draggingIndex === draggableIndex,
    sort: sort,
    tabType: tabType
  })), [columnHeaders, timelineId, draggingIndex, sort, tabType]);
  const DroppableContent = (0, _react.useCallback)((dropProvided, snapshot) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_styles.EventsThGroupData, (0, _extends2.default)({
    "data-test-subj": "headers-group",
    ref: dropProvided.innerRef,
    isDragging: snapshot.isDraggingOver
  }, dropProvided.droppableProps), ColumnHeaderList)), [ColumnHeaderList]);
  const leadingHeaderCells = (0, _react.useMemo)(() => leadingControlColumns ? leadingControlColumns.map(column => column.headerCellRender) : [], [leadingControlColumns]);
  const trailingHeaderCells = (0, _react.useMemo)(() => trailingControlColumns ? trailingControlColumns.map(column => column.headerCellRender) : [], [trailingControlColumns]);
  const fieldBrowserOptions = (0, _fields_browser.useFieldBrowserOptions)({
    sourcererScope: _model.SourcererScopeName.timeline,
    editorActionsRef: fieldEditorActionsRef,
    upsertColumn: (column, index) => dispatch((0, _actions.upsertColumn)({
      column,
      id: timelineId,
      index
    })),
    removeColumn: columnId => dispatch((0, _actions.removeColumn)({
      columnId,
      id: timelineId
    }))
  });
  const LeadingHeaderActions = (0, _react.useMemo)(() => {
    return leadingHeaderCells.map((Header, index) => {
      const passedWidth = leadingControlColumns[index] && leadingControlColumns[index].width;
      const width = passedWidth ? passedWidth : actionsColumnWidth;
      return /*#__PURE__*/_react.default.createElement(_styles.EventsThGroupActions, {
        actionsColumnWidth: width,
        "data-test-subj": "actions-container",
        isEventViewer: isEventViewer,
        key: index
      }, Header && /*#__PURE__*/_react.default.createElement(Header, {
        width: width,
        browserFields: browserFields,
        columnHeaders: columnHeaders,
        isEventViewer: isEventViewer,
        isSelectAllChecked: isSelectAllChecked,
        onSelectAll: onSelectAll,
        showEventsSelect: showEventsSelect,
        showSelectAllCheckbox: showSelectAllCheckbox,
        sort: sort,
        tabType: tabType,
        timelineId: timelineId,
        fieldBrowserOptions: fieldBrowserOptions
      }));
    });
  }, [leadingHeaderCells, leadingControlColumns, actionsColumnWidth, browserFields, columnHeaders, fieldBrowserOptions, isEventViewer, isSelectAllChecked, onSelectAll, showEventsSelect, showSelectAllCheckbox, sort, tabType, timelineId]);
  const TrailingHeaderActions = (0, _react.useMemo)(() => {
    return trailingHeaderCells.map((Header, index) => {
      const passedWidth = trailingControlColumns[index] && trailingControlColumns[index].width;
      const width = passedWidth ? passedWidth : actionsColumnWidth;
      return /*#__PURE__*/_react.default.createElement(_styles.EventsThGroupActions, {
        actionsColumnWidth: width,
        "data-test-subj": "actions-container",
        isEventViewer: isEventViewer,
        key: index
      }, Header && /*#__PURE__*/_react.default.createElement(Header, {
        width: width,
        browserFields: browserFields,
        columnHeaders: columnHeaders,
        isEventViewer: isEventViewer,
        isSelectAllChecked: isSelectAllChecked,
        onSelectAll: onSelectAll,
        showEventsSelect: showEventsSelect,
        showSelectAllCheckbox: showSelectAllCheckbox,
        sort: sort,
        tabType: tabType,
        timelineId: timelineId,
        fieldBrowserOptions: fieldBrowserOptions
      }));
    });
  }, [trailingHeaderCells, trailingControlColumns, actionsColumnWidth, browserFields, columnHeaders, fieldBrowserOptions, isEventViewer, isSelectAllChecked, onSelectAll, showEventsSelect, showSelectAllCheckbox, sort, tabType, timelineId]);
  return /*#__PURE__*/_react.default.createElement(_styles.EventsThead, {
    "data-test-subj": "column-headers"
  }, /*#__PURE__*/_react.default.createElement(_styles.EventsTrHeader, null, LeadingHeaderActions, /*#__PURE__*/_react.default.createElement(_dnd.Droppable, {
    direction: 'horizontal',
    droppableId: `${_helpers.droppableTimelineColumnsPrefix}-${tabType}.${timelineId}`,
    isDropDisabled: false,
    type: _helpers.DRAG_TYPE_FIELD,
    renderClone: renderClone
  }, DroppableContent), TrailingHeaderActions));
};
exports.ColumnHeadersComponent = ColumnHeadersComponent;
const ColumnHeaders = exports.ColumnHeaders = /*#__PURE__*/_react.default.memo(ColumnHeadersComponent);