"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderToolTipContent = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _helpers = require("../../../../../../common/components/event_details/helpers");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const IconType = (0, _styledComponents.default)(_eui.EuiIcon)`
  margin-right: 3px;
  position: relative;
  top: -2px;
`;
IconType.displayName = 'IconType';
const P = _styledComponents.default.span`
  margin-bottom: 5px;
`;
P.displayName = 'P';
const ToolTipTableMetadata = _styledComponents.default.span`
  margin-right: 5px;
  display: block;
  font-weight: bold;
`;
ToolTipTableMetadata.displayName = 'ToolTipTableMetadata';
const ToolTipTableValue = _styledComponents.default.span`
  word-wrap: break-word;
`;
ToolTipTableValue.displayName = 'ToolTipTableValue';
const HeaderToolTipContent = exports.HeaderToolTipContent = /*#__PURE__*/_react.default.memo(({
  header
}) => {
  var _header$esTypes;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !(0, _fp.isEmpty)(header.category) && /*#__PURE__*/_react.default.createElement(P, null, /*#__PURE__*/_react.default.createElement(ToolTipTableMetadata, {
    "data-test-subj": "category"
  }, i18n.CATEGORY, ':'), /*#__PURE__*/_react.default.createElement(ToolTipTableValue, {
    "data-test-subj": "category-value"
  }, header.category)), /*#__PURE__*/_react.default.createElement(P, null, /*#__PURE__*/_react.default.createElement(ToolTipTableMetadata, {
    "data-test-subj": "field"
  }, i18n.FIELD, ':'), /*#__PURE__*/_react.default.createElement(ToolTipTableValue, {
    "data-test-subj": "field-value"
  }, header.id)), /*#__PURE__*/_react.default.createElement(P, null, /*#__PURE__*/_react.default.createElement(ToolTipTableMetadata, {
    "data-test-subj": "type"
  }, i18n.TYPE, ':'), /*#__PURE__*/_react.default.createElement(ToolTipTableValue, null, /*#__PURE__*/_react.default.createElement(IconType, {
    "data-test-subj": "type-icon",
    type: (0, _helpers.getIconFromType)(header.type)
  }), (_header$esTypes = header.esTypes) === null || _header$esTypes === void 0 ? void 0 : _header$esTypes.map(esType => /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    "data-test-subj": `type-value-${esType}`,
    key: esType
  }, esType)))), !(0, _fp.isEmpty)(header.description) && /*#__PURE__*/_react.default.createElement(P, null, /*#__PURE__*/_react.default.createElement(ToolTipTableMetadata, {
    "data-test-subj": "description"
  }, i18n.DESCRIPTION, ':'), /*#__PURE__*/_react.default.createElement(ToolTipTableValue, {
    "data-test-subj": "description-value"
  }, header.description)));
});
HeaderToolTipContent.displayName = 'HeaderToolTipContent';