"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EventsSelect = exports.EVENTS_SELECT_WIDTH = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _styledComponents = _interopRequireWildcard(require("styled-components"));
var _helpers = require("./helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EVENTS_SELECT_WIDTH = exports.EVENTS_SELECT_WIDTH = 60; // px

// SIDE EFFECT: the following `createGlobalStyle` overrides
// the style of the select items
const EventsSelectGlobalStyle = (0, _styledComponents.createGlobalStyle)`
  .eventsSelectItem {
    width: 100% !important;

    .euiContextMenu__icon {
      display: none !important;
    }
  }

  .eventsSelectDropdown {
    width: ${EVENTS_SELECT_WIDTH}px;
  }
`;
const CheckboxContainer = _styledComponents.default.div`
  position: relative;
`;
CheckboxContainer.displayName = 'CheckboxContainer';
const PositionedCheckbox = _styledComponents.default.div`
  left: 7px;
  position: absolute;
  top: -28px;
`;
PositionedCheckbox.displayName = 'PositionedCheckbox';
const EventsSelect = exports.EventsSelect = /*#__PURE__*/_react.default.memo(({
  checkState,
  timelineId
}) => {
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "events-select"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    className: "eventsSelectDropdown",
    "data-test-subj": "events-select-dropdown",
    itemClassName: "eventsSelectItem",
    onChange: _fp.noop,
    options: (0, _helpers.getEventsSelectOptions)()
  }), /*#__PURE__*/_react.default.createElement(CheckboxContainer, {
    "data-test-subj": "timeline-events-select-checkbox-container"
  }, /*#__PURE__*/_react.default.createElement(PositionedCheckbox, {
    "data-test-subj": "timeline-events-select-positioned-checkbox"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCheckbox, {
    checked: checkState === 'checked',
    "data-test-subj": "events-select-checkbox",
    disabled: true,
    id: `timeline-${timelineId}-events-select`,
    indeterminate: checkState === 'indeterminate',
    onChange: _fp.noop
  }))), /*#__PURE__*/_react.default.createElement(EventsSelectGlobalStyle, null));
});
EventsSelect.displayName = 'EventsSelect';