"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ColumnHeader = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _dnd = require("@hello-pangea/dnd");
var _reResizable = require("re-resizable");
var _reactRedux = require("react-redux");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _securitysolutionTGrid = require("@kbn/securitysolution-t-grid");
var _draggable_keyboard_wrapper_hook = require("../../../../../common/components/drag_and_drop/draggable_keyboard_wrapper_hook");
var _constants = require("../constants");
var _helpers = require("../../../../../common/components/drag_and_drop/helpers");
var _timeline = require("../../../../../../common/types/timeline");
var _search_strategy = require("../../../../../../common/search_strategy");
var _helpers2 = require("../../helpers");
var _styles = require("../../styles");
var _header = require("./header");
var _store = require("../../../../store");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ContextMenu = (0, _styledComponents.default)(_eui.EuiContextMenu)`
  width: 115px;

  & .euiContextMenuItem {
    font-size: 12px;
    padding: 4px 8px;
    width: 115px;
  }
`;
const PopoverContainer = _styledComponents.default.div`
  & .euiPopover {
    padding-right: 8px;
    width: ${({
  $width
}) => $width}px;
  }
`;
const RESIZABLE_ENABLE = {
  right: true
};
const ColumnHeaderComponent = ({
  draggableIndex,
  header,
  timelineId,
  isDragging,
  onFilterChange,
  sort,
  tabType
}) => {
  const keyboardHandlerRef = (0, _react.useRef)(null);
  const [hoverActionsOwnFocus, setHoverActionsOwnFocus] = (0, _react.useState)(false);
  const restoreFocus = (0, _react.useCallback)(() => {
    var _keyboardHandlerRef$c;
    return (_keyboardHandlerRef$c = keyboardHandlerRef.current) === null || _keyboardHandlerRef$c === void 0 ? void 0 : _keyboardHandlerRef$c.focus();
  }, []);
  const dispatch = (0, _reactRedux.useDispatch)();
  const resizableSize = (0, _react.useMemo)(() => {
    var _header$initialWidth;
    return {
      width: (_header$initialWidth = header.initialWidth) !== null && _header$initialWidth !== void 0 ? _header$initialWidth : _constants.DEFAULT_COLUMN_MIN_WIDTH,
      height: 'auto'
    };
  }, [header.initialWidth]);
  const resizableStyle = (0, _react.useMemo)(() => ({
    position: isDragging ? 'absolute' : 'relative'
  }), [isDragging]);
  const resizableHandleComponent = (0, _react.useMemo)(() => ({
    right: /*#__PURE__*/_react.default.createElement(_styles.EventsHeadingHandle, null)
  }), []);
  const handleResizeStop = (0, _react.useCallback)((e, direction, ref, delta) => {
    dispatch(_store.timelineActions.applyDeltaToColumnWidth({
      columnId: header.id,
      delta: delta.width,
      id: timelineId
    }));
  }, [dispatch, header.id, timelineId]);
  const draggableId = (0, _react.useMemo)(() => (0, _helpers.getDraggableFieldId)({
    contextId: `timeline-column-headers-${tabType}-${timelineId}`,
    fieldId: header.id
  }), [tabType, timelineId, header.id]);
  const onColumnSort = (0, _react.useCallback)(sortDirection => {
    var _header$type, _header$esTypes;
    const columnId = header.id;
    const columnType = (_header$type = header.type) !== null && _header$type !== void 0 ? _header$type : '';
    const esTypes = (_header$esTypes = header.esTypes) !== null && _header$esTypes !== void 0 ? _header$esTypes : [];
    const headerIndex = sort.findIndex(col => col.columnId === columnId);
    const newSort = headerIndex === -1 ? [...sort, {
      columnId,
      columnType,
      esTypes,
      sortDirection
    }] : [...sort.slice(0, headerIndex), {
      columnId,
      columnType,
      esTypes,
      sortDirection
    }, ...sort.slice(headerIndex + 1)];
    dispatch(_store.timelineActions.updateSort({
      id: timelineId,
      sort: newSort
    }));
  }, [dispatch, header, sort, timelineId]);
  const handleClosePopOverTrigger = (0, _react.useCallback)(() => {
    setHoverActionsOwnFocus(false);
    restoreFocus();
  }, [restoreFocus]);
  const panels = (0, _react.useMemo)(() => [{
    id: 0,
    items: [{
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "eyeClosed",
        size: "s"
      }),
      name: i18n.HIDE_COLUMN,
      onClick: () => {
        dispatch(_store.timelineActions.removeColumn({
          id: timelineId,
          columnId: header.id
        }));
        handleClosePopOverTrigger();
      }
    }, ...(tabType !== _timeline.TimelineTabs.eql ? [{
      disabled: !header.aggregatable,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "sortUp",
        size: "s"
      }),
      name: i18n.SORT_AZ,
      onClick: () => {
        onColumnSort(_search_strategy.Direction.asc);
        handleClosePopOverTrigger();
      }
    }, {
      disabled: !header.aggregatable,
      icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "sortDown",
        size: "s"
      }),
      name: i18n.SORT_ZA,
      onClick: () => {
        onColumnSort(_search_strategy.Direction.desc);
        handleClosePopOverTrigger();
      }
    }] : [])]
  }], [dispatch, handleClosePopOverTrigger, header.aggregatable, header.id, onColumnSort, tabType, timelineId]);
  const headerButton = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_header.Header, {
    timelineId: timelineId,
    header: header,
    onFilterChange: onFilterChange,
    sort: sort
  }), [header, onFilterChange, sort, timelineId]);
  const DraggableContent = (0, _react.useCallback)(dragProvided => {
    var _header$initialWidth2;
    return /*#__PURE__*/_react.default.createElement(_styles.EventsTh, (0, _extends2.default)({
      "data-test-subj": "draggable-header"
    }, dragProvided.draggableProps, dragProvided.dragHandleProps, {
      ref: dragProvided.innerRef
    }), /*#__PURE__*/_react.default.createElement(_styles.EventsThContent, null, /*#__PURE__*/_react.default.createElement(PopoverContainer, {
      $width: (_header$initialWidth2 = header.initialWidth) !== null && _header$initialWidth2 !== void 0 ? _header$initialWidth2 : _constants.DEFAULT_COLUMN_MIN_WIDTH
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      anchorPosition: "downLeft",
      button: headerButton,
      closePopover: handleClosePopOverTrigger,
      isOpen: hoverActionsOwnFocus,
      ownFocus: true,
      panelPaddingSize: "none"
    }, /*#__PURE__*/_react.default.createElement(ContextMenu, {
      initialPanelId: 0,
      panels: panels
    })))));
  }, [handleClosePopOverTrigger, headerButton, header.initialWidth, hoverActionsOwnFocus, panels]);
  const onFocus = (0, _react.useCallback)(() => {
    var _keyboardHandlerRef$c2;
    (_keyboardHandlerRef$c2 = keyboardHandlerRef.current) === null || _keyboardHandlerRef$c2 === void 0 ? void 0 : _keyboardHandlerRef$c2.focus();
  }, []);
  const openPopover = (0, _react.useCallback)(() => {
    setHoverActionsOwnFocus(true);
  }, []);
  const {
    onBlur,
    onKeyDown
  } = (0, _draggable_keyboard_wrapper_hook.useDraggableKeyboardWrapper)({
    closePopover: handleClosePopOverTrigger,
    draggableId,
    fieldName: header.id,
    keyboardHandlerRef,
    openPopover
  });
  const keyDownHandler = (0, _react.useCallback)(keyboardEvent => {
    if (!hoverActionsOwnFocus) {
      onKeyDown(keyboardEvent);
    }
  }, [hoverActionsOwnFocus, onKeyDown]);
  return /*#__PURE__*/_react.default.createElement(_reResizable.Resizable, {
    enable: RESIZABLE_ENABLE,
    size: resizableSize,
    style: resizableStyle,
    handleComponent: resizableHandleComponent,
    onResizeStop: handleResizeStop
  }, /*#__PURE__*/_react.default.createElement("div", {
    "aria-colindex": draggableIndex != null ? draggableIndex + _helpers2.ARIA_COLUMN_INDEX_OFFSET : undefined,
    className: _securitysolutionTGrid.DRAGGABLE_KEYBOARD_WRAPPER_CLASS_NAME,
    "data-test-subj": "draggableWrapperKeyboardHandler",
    onClick: onFocus,
    onBlur: onBlur,
    onKeyDown: keyDownHandler,
    ref: keyboardHandlerRef,
    role: "columnheader",
    tabIndex: 0
  }, /*#__PURE__*/_react.default.createElement(_dnd.Draggable, {
    "data-test-subj": "draggable"
    // Required for drag events while hovering the sort button to work: https://github.com/atlassian/react-beautiful-dnd/blob/master/docs/api/draggable.md#interactive-child-elements-within-a-draggable-
    ,
    disableInteractiveElementBlocking: true,
    draggableId: draggableId,
    index: draggableIndex,
    key: header.id
  }, DraggableContent)));
};
const ColumnHeader = exports.ColumnHeader = /*#__PURE__*/_react.default.memo(ColumnHeaderComponent);