"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRefetchByScope = void 0;
var _react = require("react");
var _use_selector = require("../../../../../common/hooks/use_selector");
var _helpers = require("../../../../../helpers");
var _store = require("../../../../../common/store");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Hook to refetch data within specified scope
 */
const useRefetchByScope = ({
  scopeId
}) => {
  const getGlobalQueries = (0, _react.useMemo)(() => _store.inputsSelectors.globalQuery(), []);
  const getTimelineQuery = (0, _react.useMemo)(() => _store.inputsSelectors.timelineQueryByIdSelector(), []);
  const {
    globalQuery,
    timelineQuery
  } = (0, _use_selector.useDeepEqualSelector)(state => ({
    globalQuery: getGlobalQueries(state),
    timelineQuery: getTimelineQuery(state, scopeId)
  }));
  const refetchAll = (0, _react.useCallback)(() => {
    const refetchQuery = newQueries => {
      newQueries.forEach(q => q.refetch && q.refetch());
    };
    if ((0, _helpers.isActiveTimeline)(scopeId)) {
      refetchQuery([timelineQuery]);
    } else {
      refetchQuery(globalQuery);
    }
  }, [scopeId, timelineQuery, globalQuery]);
  return {
    refetch: refetchAll
  };
};
exports.useRefetchByScope = useRefetchByScope;