"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BackToAlertDetailsLink = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireDefault(require("react"));
var _translations = require("../../../../../detections/components/host_isolation/translations");
var _translations2 = require("../translations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BackToAlertDetailsLinkComponent = ({
  showAlertDetails,
  showExperimentalBadge,
  isolateAction
}) => /*#__PURE__*/_react2.default.createElement(_react2.default.Fragment, null, /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonEmpty, {
  iconType: "arrowLeft",
  iconSide: "left",
  flush: "left",
  onClick: showAlertDetails
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
  size: "xs"
}, /*#__PURE__*/_react2.default.createElement("p", null, _translations2.ALERT_DETAILS))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "s"
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react2.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react2.default.createElement("h2", null, isolateAction === 'isolateHost' ? _translations.ISOLATE_HOST : _translations.UNISOLATE_HOST))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, showExperimentalBadge && /*#__PURE__*/_react2.default.createElement(_eui.EuiBetaBadge, {
  css: (0, _react.css)`
              display: inline-flex;
            `,
  label: _translations2.TECHNICAL_PREVIEW,
  size: "s",
  tooltipContent: _translations2.TECHNICAL_PREVIEW_DESCRIPTION
}))));
const BackToAlertDetailsLink = exports.BackToAlertDetailsLink = /*#__PURE__*/_react2.default.memo(BackToAlertDetailsLinkComponent);