"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableEventTitle = exports.ExpandableEvent = void 0;
var _elasticAssistant = require("@kbn/elastic-assistant");
var _fp = require("lodash/fp");
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _panel_keys = require("../../../../flyout/document_details/shared/constants/panel_keys");
var _use_url_state = require("../../../../common/hooks/use_url_state");
var _assignees = require("../../../../flyout/document_details/right/components/assignees");
var _use_assistant_availability = require("../../../../assistant/use_assistant_availability");
var _event_details = require("../../../../common/components/event_details/event_details");
var i18n = _interopRequireWildcard(require("./translations"));
var _translations2 = require("../../../../common/components/event_details/translations");
var _formatted_date = require("../../../../common/components/formatted_date");
var _use_get_alert_details_flyout_link = require("./use_get_alert_details_flyout_link");
var _use_refetch_by_scope = require("./flyout/use_refetch_by_scope");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const StyledEuiFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex: 0 1 auto;
  ${({
  theme
}) => `margin-top: ${theme.eui.euiSizeS};`}
`;
const StyledFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  height: 100%;
`;
const StyledEuiFlexItem = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  &.euiFlexItem {
    flex: 1 0 0;
    overflow: hidden;
  }
`;
const ExpandableEventTitle = exports.ExpandableEventTitle = /*#__PURE__*/_react.default.memo(({
  eventId,
  eventIndex,
  isAlert,
  loading,
  handleOnEventClosed,
  promptContextId,
  ruleName,
  timestamp,
  scopeId,
  refetchFlyoutData,
  getFieldsData
}) => {
  const {
    hasAssistantPrivilege
  } = (0, _use_assistant_availability.useAssistantAvailability)();
  const alertDetailsLink = (0, _use_get_alert_details_flyout_link.useGetAlertDetailsFlyoutLink)({
    _id: eventId,
    _index: eventIndex,
    timestamp
  });
  const urlModifier = value => {
    // this is actually only needed for when users click on the Share Alert button and then enable the expandable flyout
    // (for the old (non-expandable) flyout, we do not need to save anything in the url as we automatically open the flyout here: x-pack/plugins/security_solution/public/detections/pages/alerts/alert_details_redirect.tsx
    return `${value}&${_use_url_state.URL_PARAM_KEY.flyout}=(preview:!(),right:(id:${_panel_keys.DocumentDetailsRightPanelKey},params:(id:'${eventId}',indexName:${eventIndex},scopeId:${scopeId})))`;
  };
  const {
    refetch
  } = (0, _use_refetch_by_scope.useRefetchByScope)({
    scopeId
  });
  const alertAssignees = (0, _react.useMemo)(() => {
    var _ref;
    return (_ref = getFieldsData(_ruleDataUtils.ALERT_WORKFLOW_ASSIGNEE_IDS)) !== null && _ref !== void 0 ? _ref : [];
  }, [getFieldsData]);
  const onAssigneesUpdated = (0, _react.useCallback)(() => {
    refetch();
    refetchFlyoutData();
  }, [refetch, refetchFlyoutData]);
  return /*#__PURE__*/_react.default.createElement(StyledEuiFlexGroup, {
    gutterSize: "none",
    justifyContent: "spaceBetween",
    wrap: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, !loading && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("h4", null, isAlert && !(0, _fp.isEmpty)(ruleName) ? ruleName : i18n.EVENT_DETAILS)), timestamp && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_formatted_date.PreferenceFormattedDate, {
    value: new Date(timestamp)
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    alignItems: "flexEnd",
    gutterSize: "none"
  }, handleOnEventClosed && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": i18n.CLOSE,
    onClick: handleOnEventClosed
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    direction: "row",
    gutterSize: "none"
  }, hasAssistantPrivilege && promptContextId != null && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_elasticAssistant.NewChatByTitle, {
    conversationTitle: isAlert ? _translations2.ALERT_SUMMARY_CONVERSATION_ID : _translations2.EVENT_SUMMARY_CONVERSATION_ID,
    promptContextId: promptContextId
  })), isAlert && alertDetailsLink && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: urlModifier(alertDetailsLink)
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: copy,
    iconType: "share",
    "data-test-subj": "copy-alert-flyout-link"
  }, i18n.SHARE_ALERT))))), isAlert && scopeId !== _securitysolutionDataTable.TableId.rulePreview && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_assignees.Assignees, {
    eventId: eventId,
    assignedUserIds: alertAssignees,
    onAssigneesUpdated: onAssigneesUpdated
  })))));
});
ExpandableEventTitle.displayName = 'ExpandableEventTitle';
const ExpandableEvent = exports.ExpandableEvent = /*#__PURE__*/_react.default.memo(({
  browserFields,
  event,
  scopeId,
  timelineTabType,
  isAlert,
  isDraggable,
  loading,
  detailsData,
  detailsEcsData,
  rawEventData,
  handleOnEventClosed,
  isReadOnly
}) => {
  if (!event.eventId) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, i18n.EVENT_DETAILS_PLACEHOLDER);
  }
  if (loading) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
      lines: 10
    });
  }
  return /*#__PURE__*/_react.default.createElement(StyledFlexGroup, {
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(StyledEuiFlexItem, {
    grow: true
  }, /*#__PURE__*/_react.default.createElement(_event_details.EventDetails, {
    browserFields: browserFields,
    data: detailsData !== null && detailsData !== void 0 ? detailsData : [],
    detailsEcsData: detailsEcsData,
    id: event.eventId,
    isAlert: isAlert,
    isDraggable: isDraggable,
    rawEventData: rawEventData,
    scopeId: scopeId,
    timelineTabType: timelineTabType,
    handleOnEventClosed: handleOnEventClosed,
    isReadOnly: isReadOnly
  })));
});
ExpandableEvent.displayName = 'ExpandableEvent';