"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionsColumns = void 0;
var i18n = _interopRequireWildcard(require("../translations"));
var _timeline = require("../../../../../common/api/timeline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns the action columns (e.g. delete, open duplicate timeline)
 */
const getActionsColumns = ({
  actionTimelineToShow,
  deleteTimelines,
  enableExportTimelineDownloader,
  onOpenDeleteTimelineModal,
  onOpenTimeline,
  onCreateRule,
  onCreateRuleFromEql,
  hasCrudAccess
}) => {
  const createTimelineFromTemplate = {
    name: i18n.CREATE_TIMELINE_FROM_TEMPLATE,
    icon: 'timeline',
    onClick: ({
      savedObjectId
    }) => {
      onOpenTimeline({
        duplicate: true,
        timelineType: _timeline.TimelineType.default,
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        timelineId: savedObjectId
      });
    },
    type: 'icon',
    enabled: ({
      savedObjectId
    }) => savedObjectId != null,
    description: i18n.CREATE_TIMELINE_FROM_TEMPLATE,
    'data-test-subj': 'create-from-template',
    available: item => item.timelineType === _timeline.TimelineType.template && actionTimelineToShow.includes('createFrom')
  };
  const createTemplateFromTimeline = {
    name: i18n.CREATE_TEMPLATE_FROM_TIMELINE,
    icon: 'visText',
    onClick: ({
      savedObjectId
    }) => {
      onOpenTimeline({
        duplicate: true,
        timelineType: _timeline.TimelineType.template,
        // eslint-disable-next-line @typescript-eslint/no-non-null-assertion
        timelineId: savedObjectId
      });
    },
    type: 'icon',
    enabled: ({
      savedObjectId
    }) => savedObjectId != null,
    description: i18n.CREATE_TEMPLATE_FROM_TIMELINE,
    'data-test-subj': 'create-template-from-timeline',
    available: item => item.timelineType !== _timeline.TimelineType.template && actionTimelineToShow.includes('createFrom')
  };
  const openAsDuplicateColumn = {
    name: i18n.OPEN_AS_DUPLICATE,
    icon: 'copy',
    onClick: ({
      savedObjectId
    }) => {
      onOpenTimeline({
        duplicate: true,
        timelineId: savedObjectId !== null && savedObjectId !== void 0 ? savedObjectId : ''
      });
    },
    type: 'icon',
    enabled: ({
      savedObjectId
    }) => savedObjectId != null,
    description: i18n.OPEN_AS_DUPLICATE,
    'data-test-subj': 'open-duplicate',
    available: item => item.timelineType !== _timeline.TimelineType.template && actionTimelineToShow.includes('duplicate')
  };
  const openAsDuplicateTemplateColumn = {
    name: i18n.OPEN_AS_DUPLICATE_TEMPLATE,
    icon: 'copy',
    onClick: ({
      savedObjectId
    }) => {
      onOpenTimeline({
        duplicate: true,
        timelineId: savedObjectId !== null && savedObjectId !== void 0 ? savedObjectId : ''
      });
    },
    type: 'icon',
    enabled: ({
      savedObjectId
    }) => savedObjectId != null,
    description: i18n.OPEN_AS_DUPLICATE_TEMPLATE,
    'data-test-subj': 'open-duplicate-template',
    available: item => item.timelineType === _timeline.TimelineType.template && actionTimelineToShow.includes('duplicate')
  };
  const exportTimelineAction = {
    name: i18n.EXPORT_SELECTED,
    icon: 'exportAction',
    onClick: selectedTimeline => {
      if (enableExportTimelineDownloader != null) enableExportTimelineDownloader(selectedTimeline);
    },
    enabled: timeline => {
      return timeline.savedObjectId != null && timeline.status !== _timeline.TimelineStatus.immutable;
    },
    description: i18n.EXPORT_SELECTED,
    'data-test-subj': 'export-timeline',
    available: () => actionTimelineToShow.includes('export')
  };
  const deleteTimelineColumn = {
    name: i18n.DELETE_SELECTED,
    icon: 'trash',
    onClick: selectedTimeline => {
      if (onOpenDeleteTimelineModal != null) onOpenDeleteTimelineModal(selectedTimeline);
    },
    enabled: ({
      savedObjectId,
      status
    }) => savedObjectId != null && status !== _timeline.TimelineStatus.immutable,
    description: i18n.DELETE_SELECTED,
    'data-test-subj': 'delete-timeline',
    available: () => actionTimelineToShow.includes('delete') && deleteTimelines != null
  };
  const createRuleFromTimeline = {
    name: i18n.CREATE_RULE_FROM_TIMELINE,
    icon: 'indexEdit',
    onClick: selectedTimeline => {
      if (onCreateRule != null && selectedTimeline.savedObjectId) onCreateRule(selectedTimeline.savedObjectId);
    },
    enabled: timeline => onCreateRule != null && timeline.savedObjectId != null && timeline.status !== _timeline.TimelineStatus.immutable,
    description: i18n.CREATE_RULE_FROM_TIMELINE,
    'data-test-subj': 'create-rule-from-timeline',
    available: ({
      queryType
    }) => actionTimelineToShow.includes('createRule') && onCreateRule != null && queryType != null && queryType.hasQuery
  };
  const createRuleFromTimelineCorrelation = {
    name: i18n.CREATE_RULE_FROM_TIMELINE_CORRELATION,
    icon: 'indexEdit',
    onClick: selectedTimeline => {
      if (onCreateRuleFromEql != null && selectedTimeline.savedObjectId) onCreateRuleFromEql(selectedTimeline.savedObjectId);
    },
    enabled: timeline => onCreateRuleFromEql != null && timeline.savedObjectId != null && timeline.status !== _timeline.TimelineStatus.immutable,
    description: i18n.CREATE_RULE_FROM_TIMELINE,
    'data-test-subj': 'create-rule-from-eql',
    available: ({
      queryType
    }) => actionTimelineToShow.includes('createRuleFromEql') && onCreateRuleFromEql != null && queryType != null && queryType.hasEql
  };
  return [{
    width: hasCrudAccess ? '80px' : '150px',
    actions: [createTimelineFromTemplate, createTemplateFromTimeline, openAsDuplicateColumn, openAsDuplicateTemplateColumn, exportTimelineAction, deleteTimelineColumn, createRuleFromTimeline, createRuleFromTimelineCorrelation]
  }];
};
exports.getActionsColumns = getActionsColumns;