"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchRow = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _timeline = require("../../../../../common/api/timeline");
var i18n = _interopRequireWildcard(require("../translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SearchRowContainer = _styledComponents.default.div`
  &:not(:last-child) {
    margin-bottom: ${props => props.theme.eui.euiSizeL};
  }
`;
SearchRowContainer.displayName = 'SearchRowContainer';
const SearchRowFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  margin-bottom: ${props => props.theme.eui.euiSizeXS};
`;
SearchRowFlexGroup.displayName = 'SearchRowFlexGroup';
/**
 * Renders the row containing the search input and Only Favorites filter
 */
const SearchRow = exports.SearchRow = /*#__PURE__*/_react.default.memo(({
  favoriteCount,
  onlyFavorites,
  onQueryChange,
  onToggleOnlyFavorites,
  children,
  timelineType
}) => {
  const searchBox = (0, _react.useMemo)(() => ({
    placeholder: timelineType === _timeline.TimelineType.default ? i18n.SEARCH_PLACEHOLDER : i18n.SEARCH_TEMPLATE_PLACEHOLDER,
    incremental: false,
    'data-test-subj': 'search-bar'
  }), [timelineType]);
  return /*#__PURE__*/_react.default.createElement(SearchRowContainer, null, /*#__PURE__*/_react.default.createElement(SearchRowFlexGroup, {
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
    box: searchBox,
    onChange: onQueryChange
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterGroup, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFilterButton, {
    "data-test-subj": "only-favorites-toggle",
    hasActiveFilters: onlyFavorites,
    onClick: onToggleOnlyFavorites,
    numFilters: favoriteCount !== null && favoriteCount !== void 0 ? favoriteCount : undefined
  }, i18n.ONLY_FAVORITES), !!children && children)))));
});
SearchRow.displayName = 'SearchRow';