"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OpenTimelineModalBody = exports.HeaderContainer = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _search_row = require("../search_row");
var _timelines_table = require("../timelines_table");
var _title_row = require("../title_row");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderContainer = exports.HeaderContainer = _styledComponents.default.div`
  width: 100%;
`;
HeaderContainer.displayName = 'HeaderContainer';
const OpenTimelineModalBody = exports.OpenTimelineModalBody = /*#__PURE__*/(0, _react.memo)(({
  deleteTimelines,
  defaultPageSize,
  favoriteCount,
  hideActions = [],
  isLoading,
  itemIdToExpandedNotesRowMap,
  onAddTimelinesToFavorites,
  onDeleteSelected,
  onlyFavorites,
  onOpenTimeline,
  onQueryChange,
  onSelectionChange,
  onTableChange,
  onToggleOnlyFavorites,
  onToggleShowNotes,
  pageIndex,
  pageSize,
  searchResults,
  selectedItems,
  sortDirection,
  sortField,
  timelineFilter,
  timelineType,
  templateTimelineFilter,
  title,
  totalSearchResultsCount
}) => {
  const actionsToShow = (0, _react.useMemo)(() => {
    const actions = ['createFrom', 'duplicate'];
    if (onDeleteSelected != null && deleteTimelines != null) {
      actions.push('delete');
    }
    return actions.filter(action => !hideActions.includes(action));
  }, [onDeleteSelected, deleteTimelines, hideActions]);
  const SearchRowContent = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: "search-row-content"
  }, !!templateTimelineFilter && templateTimelineFilter), [templateTimelineFilter]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(HeaderContainer, null, /*#__PURE__*/_react.default.createElement(_title_row.TitleRow, {
    "data-test-subj": "title-row",
    onAddTimelinesToFavorites: onAddTimelinesToFavorites,
    selectedTimelinesCount: selectedItems.length,
    title: title
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, !!timelineFilter && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, timelineFilter, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), /*#__PURE__*/_react.default.createElement(_search_row.SearchRow, {
    "data-test-subj": "search-row",
    onlyFavorites: onlyFavorites,
    onQueryChange: onQueryChange,
    onToggleOnlyFavorites: onToggleOnlyFavorites,
    query: "",
    timelineType: timelineType
  }, SearchRowContent), /*#__PURE__*/_react.default.createElement(_timelines_table.TimelinesTable, {
    actionTimelineToShow: actionsToShow,
    "data-test-subj": "timelines-table",
    deleteTimelines: deleteTimelines,
    defaultPageSize: defaultPageSize,
    loading: isLoading,
    itemIdToExpandedNotesRowMap: itemIdToExpandedNotesRowMap,
    onOpenTimeline: onOpenTimeline,
    onSelectionChange: onSelectionChange,
    onTableChange: onTableChange,
    onToggleShowNotes: onToggleShowNotes,
    pageIndex: pageIndex,
    pageSize: pageSize,
    searchResults: searchResults,
    showExtendedColumns: false,
    sortDirection: sortDirection,
    sortField: sortField,
    timelineType: timelineType,
    totalSearchResultsCount: totalSearchResultsCount
  }))));
});
OpenTimelineModalBody.displayName = 'OpenTimelineModalBody';