"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NewTimelineButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _types = require("../../../../common/types");
var _use_create_timeline = require("../../hooks/use_create_timeline");
var _timeline = require("../../../../common/api/timeline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NEW_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timelines.newTimelineButtonLabel', {
  defaultMessage: 'Create new Timeline'
});
const NEW_TEMPLATE_TIMELINE = _i18n.i18n.translate('xpack.securitySolution.timelines.newTemplateTimelineButtonLabel', {
  defaultMessage: 'Create new Timeline template'
});
/**
 * This component renders the "Create new Timeline" or "Create new Timeline template" button depending on the timeline type passed in.
 * It is used in the Timelines page.
 */
const NewTimelineButton = exports.NewTimelineButton = /*#__PURE__*/_react.default.memo(({
  type
}) => {
  const createNewTimeline = (0, _use_create_timeline.useCreateTimeline)({
    timelineId: _types.TimelineId.active,
    timelineType: type
  });
  const dataTestSubj = `timelines-page-create-new-${type === _timeline.TimelineType.default ? 'timeline' : 'timeline-template'}`;
  const handleCreateNewTimeline = (0, _react.useCallback)(async () => {
    await createNewTimeline();
  }, [createNewTimeline]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "plusInCircle",
    "data-test-subj": dataTestSubj,
    onClick: handleCreateNewTimeline,
    fill: true
  }, type === _timeline.TimelineType.default ? NEW_TIMELINE : NEW_TEMPLATE_TIMELINE);
});
NewTimelineButton.displayName = 'NewTimelineButton';