"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserProcess = exports.USER_NAME_FIELD_NAME = exports.PROCESS_NAME_FIELD_NAME = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireDefault(require("react"));
var _draggables = require("../../../../common/components/draggables");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROCESS_NAME_FIELD_NAME = exports.PROCESS_NAME_FIELD_NAME = 'process.name';
const USER_NAME_FIELD_NAME = exports.USER_NAME_FIELD_NAME = 'user.name';

/**
 * Renders a column of draggable badges containing:
 * - `user.name`
 * - `process.name`
 */
const UserProcess = exports.UserProcess = /*#__PURE__*/_react.default.memo(({
  contextId,
  eventId,
  isDraggable,
  processName,
  userName
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "flexStart",
  "data-test-subj": "user-process",
  direction: "column",
  justifyContent: "center",
  gutterSize: "none"
}, userName != null ? (0, _fp.uniq)(userName).map(user => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: user
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  "data-test-subj": "user-name",
  eventId: eventId,
  field: USER_NAME_FIELD_NAME,
  isDraggable: isDraggable,
  value: user,
  iconType: "user",
  isAggregatable: true,
  fieldType: "keyword"
}))) : null, processName != null ? (0, _fp.uniq)(processName).map(process => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false,
  key: process
}, /*#__PURE__*/_react.default.createElement(_draggables.DraggableBadge, {
  contextId: contextId,
  eventId: eventId,
  field: PROCESS_NAME_FIELD_NAME,
  isDraggable: isDraggable,
  value: process,
  iconType: "console",
  isAggregatable: true,
  fieldType: "keyword"
}))) : null));
UserProcess.displayName = 'UserProcess';