"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SaveTimelineButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var _timeline = require("../../../../../common/api/timeline");
var _user_privileges = require("../../../../common/components/user_privileges");
var _save_timeline_modal = require("./save_timeline_modal");
var i18n = _interopRequireWildcard(require("./translations"));
var _selectors = require("../../../store/selectors");
var _step_config = require("../../timeline/tour/step_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Button that allows user to save the timeline. Clicking it opens the `SaveTimelineModal`
 */
const SaveTimelineButton = exports.SaveTimelineButton = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const [showEditTimelineOverlay, setShowEditTimelineOverlay] = (0, _react.useState)(false);
  const toggleSaveTimeline = (0, _react.useCallback)(() => setShowEditTimelineOverlay(prev => !prev), []);

  // Case: 1
  // check if user has crud privileges so that user can be allowed to edit the timeline
  // Case: 2
  // TODO: User may have Crud privileges but they may not have access to timeline index.
  // Do we need to check that?
  const {
    kibanaSecuritySolutionsPrivileges: {
      crud: canEditTimelinePrivilege
    }
  } = (0, _user_privileges.useUserPrivileges)();
  const {
    status,
    isSaving
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const canSaveTimeline = canEditTimelinePrivilege && status !== _timeline.TimelineStatus.immutable;
  const isUnsaved = status === _timeline.TimelineStatus.draft;
  const unauthorizedMessage = canSaveTimeline ? null : i18n.CALL_OUT_UNAUTHORIZED_MSG;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: unauthorizedMessage,
    position: "bottom",
    "data-test-subj": "timeline-modal-save-timeline-tooltip"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    id: _step_config.TIMELINE_TOUR_CONFIG_ANCHORS.SAVE_TIMELINE,
    fill: true,
    size: "s",
    iconType: "save",
    isLoading: isSaving,
    disabled: !canSaveTimeline,
    "data-test-subj": "timeline-modal-save-timeline",
    onClick: toggleSaveTimeline
  }, i18n.SAVE)), showEditTimelineOverlay && canSaveTimeline ? /*#__PURE__*/_react.default.createElement(_save_timeline_modal.SaveTimelineModal, {
    initialFocusOn: isUnsaved ? 'title' : 'save',
    timelineId: timelineId,
    showWarning: false,
    closeSaveTimeline: toggleSaveTimeline
  }) : null);
});
SaveTimelineButton.displayName = 'SaveTimelineButton';