"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttachToCaseButton = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _translations = require("../../timeline/properties/translations");
var _selectors = require("../../../store/selectors");
var _constants = require("../../../../../common/constants");
var _actions = require("../../../store/actions");
var _kibana = require("../../../../common/lib/kibana");
var _timeline = require("../../../../../common/types/timeline");
var _timeline2 = require("../../../../../common/api/timeline");
var _link_to = require("../../../../common/components/link_to");
var _types = require("../../../../app/types");
var i18n = _interopRequireWildcard(require("./translations"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Button that opens a popover with options to attach the timeline to new or existing case
 */
const AttachToCaseButton = exports.AttachToCaseButton = /*#__PURE__*/_react.default.memo(({
  timelineId
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    graphEventId,
    savedObjectId,
    status: timelineStatus,
    title: timelineTitle,
    timelineType
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const {
    cases,
    application: {
      navigateToApp
    }
  } = (0, _kibana.useKibana)().services;
  const userCasesPermissions = cases.helpers.canUseCases([_constants.APP_ID]);
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const [isCaseModalOpen, openCaseModal] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setPopover(currentIsOpen => !currentIsOpen), []);
  const closeCaseModal = (0, _react.useCallback)(() => openCaseModal(false), [openCaseModal]);
  const onRowClick = (0, _react.useCallback)(async theCase => {
    closeCaseModal();
    await navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.case,
      path: theCase != null ? (0, _link_to.getCaseDetailsUrl)({
        id: theCase.id
      }) : (0, _link_to.getCreateCaseUrl)()
    });
    dispatch((0, _actions.setInsertTimeline)({
      graphEventId,
      timelineId,
      timelineSavedObjectId: savedObjectId,
      timelineTitle
    }));
  }, [closeCaseModal, dispatch, graphEventId, navigateToApp, savedObjectId, timelineId, timelineTitle]);
  const attachToNewCase = (0, _react.useCallback)(() => {
    togglePopover();
    navigateToApp(_constants.APP_UI_ID, {
      deepLinkId: _types.SecurityPageName.case,
      path: (0, _link_to.getCreateCaseUrl)()
    }).then(() => {
      dispatch((0, _actions.setInsertTimeline)({
        graphEventId,
        timelineId,
        timelineSavedObjectId: savedObjectId,
        timelineTitle: timelineTitle.length > 0 ? timelineTitle : _translations.UNTITLED_TIMELINE
      }));
      dispatch((0, _actions.showTimeline)({
        id: _timeline.TimelineId.active,
        show: false
      }));
    });
  }, [dispatch, graphEventId, navigateToApp, savedObjectId, timelineId, timelineTitle, togglePopover]);
  const attachToExistingCase = (0, _react.useCallback)(() => {
    togglePopover();
    openCaseModal(true);
  }, [togglePopover, openCaseModal]);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowDown",
    iconSide: "right",
    disabled: timelineStatus === _timeline2.TimelineStatus.draft || timelineType !== _timeline2.TimelineType.default,
    "data-test-subj": "timeline-modal-attach-to-case-dropdown-button",
    onClick: togglePopover
  }, i18n.ATTACH_TO_CASE), [togglePopover, timelineStatus, timelineType]);
  const items = (0, _react.useMemo)(() => [/*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "new-case",
    "data-test-subj": "timeline-modal-attach-timeline-to-new-case",
    onClick: attachToNewCase
  }, i18n.ATTACH_TO_NEW_CASE), /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuItem, {
    key: "existing-case",
    "data-test-subj": "timeline-modal-attach-timeline-to-existing-case",
    onClick: attachToExistingCase
  }, i18n.ATTACH_TO_EXISTING_CASE)], [attachToExistingCase, attachToNewCase]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: togglePopover,
    panelPaddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenuPanel, {
    items: items
  })), isCaseModalOpen && cases.ui.getAllCasesSelectorModal({
    onRowClick,
    onClose: closeCaseModal,
    owner: [_constants.APP_ID],
    permissions: userCasesPermissions
  }));
});
AttachToCaseButton.displayName = 'AttachToCaseButton';