"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.whoisRenderer = exports.reputationRenderer = exports.locationRenderer = exports.hostNameRenderer = exports.hostIdRenderer = exports.dateRenderer = exports.autonomousSystemRenderer = exports.MoreContainer = exports.IpOverviewId = exports.DefaultFieldRendererOverflow = exports.DefaultFieldRendererComponent = exports.DefaultFieldRenderer = exports.DEFAULT_MORE_MAX_HEIGHT = void 0;
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _cell_actions = require("../../../common/components/cell_actions");
var _helpers = require("../../../common/components/drag_and_drop/helpers");
var _draggables = require("../../../common/components/draggables");
var _empty_value = require("../../../common/components/empty_value");
var _formatted_date = require("../../../common/components/formatted_date");
var _links = require("../../../common/components/links");
var _page = require("../../../common/components/page");
var i18n = _interopRequireWildcard(require("../../../explore/network/components/details/translations"));
var _model = require("../../../common/store/sourcerer/model");
var _timeline = require("../timeline");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DraggableContainerFlexGroup = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  flex-grow: unset;
`;
const IpOverviewId = exports.IpOverviewId = 'ip-overview';

/** The default max-height of the popover used to show "+n More" items (e.g. `+9 More`) */
const DEFAULT_MORE_MAX_HEIGHT = exports.DEFAULT_MORE_MAX_HEIGHT = '200px';
const locationRenderer = (fieldNames, data, contextID, isDraggable) => fieldNames.length > 0 && fieldNames.every(fieldName => (0, _fp.getOr)(null, fieldName, data)) ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, fieldNames.map((fieldName, index) => {
  const locationValue = (0, _fp.getOr)('', fieldName, data);
  return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
    key: `${IpOverviewId}-${fieldName}`
  }, index ? ',\u00A0' : '', /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
    id: `location-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}${fieldName}`,
    isDraggable: isDraggable !== null && isDraggable !== void 0 ? isDraggable : false,
    field: fieldName,
    value: locationValue,
    isAggregatable: true,
    fieldType: 'keyword'
  })));
})) : (0, _empty_value.getEmptyTagValue)();
exports.locationRenderer = locationRenderer;
const dateRenderer = timestamp => /*#__PURE__*/_react.default.createElement(_formatted_date.FormattedRelativePreferenceDate, {
  value: timestamp
});
exports.dateRenderer = dateRenderer;
const autonomousSystemRenderer = (as, flowTarget, contextID, isDraggable) => as && as.organization && as.organization.name && as.number ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
  alignItems: "center",
  gutterSize: "none"
}, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `autonomous-system-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}${flowTarget}.as.organization.name`,
  isDraggable: isDraggable !== null && isDraggable !== void 0 ? isDraggable : false,
  field: `${flowTarget}.as.organization.name`,
  value: as.organization.name
})), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, '/'), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
  grow: false
}, /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `autonomous-system-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}${flowTarget}.as.number`,
  isDraggable: false,
  field: `${flowTarget}.as.number`,
  value: `${as.number}`,
  isAggregatable: true,
  fieldType: 'number'
}))) : (0, _empty_value.getEmptyTagValue)();
exports.autonomousSystemRenderer = autonomousSystemRenderer;
const hostIdRenderer = ({
  contextID,
  host,
  isDraggable = false,
  ipFilter,
  noLink
}) => host.id && host.ip && (ipFilter == null || host.ip.includes(ipFilter)) ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, host.name && host.name[0] != null ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `host-id-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}host-id`,
  isDraggable: isDraggable,
  field: "host.id",
  value: host.id[0],
  isAggregatable: true,
  fieldType: 'keyword'
}, noLink ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, host.id) : /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
  hostName: host.name[0]
}, host.id)) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, host.id)) : (0, _empty_value.getEmptyTagValue)();
exports.hostIdRenderer = hostIdRenderer;
const hostNameRenderer = (host, ipFilter, contextID, isDraggable) => host && host.name && host.name[0] && host.ip && (!(ipFilter != null) || host.ip.includes(ipFilter)) ? /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
  id: `host-name-renderer-default-draggable-${IpOverviewId}-${contextID ? `${contextID}-` : ''}host-name`,
  isDraggable: isDraggable !== null && isDraggable !== void 0 ? isDraggable : false,
  field: 'host.name',
  value: host.name[0],
  isAggregatable: true,
  fieldType: 'keyword'
}, /*#__PURE__*/_react.default.createElement(_links.HostDetailsLink, {
  hostName: host.name[0]
}, host.name ? host.name : (0, _empty_value.getEmptyTagValue)())) : (0, _empty_value.getEmptyTagValue)();
exports.hostNameRenderer = hostNameRenderer;
const whoisRenderer = ip => /*#__PURE__*/_react.default.createElement(_links.WhoIsLink, {
  domain: ip
}, i18n.VIEW_WHOIS);
exports.whoisRenderer = whoisRenderer;
const reputationRenderer = ip => /*#__PURE__*/_react.default.createElement(_links.ReputationLink, {
  domain: ip,
  direction: "column"
});
exports.reputationRenderer = reputationRenderer;
const DefaultFieldRendererComponent = ({
  attrName,
  displayCount = 1,
  idPrefix,
  isDraggable = false,
  moreMaxHeight = DEFAULT_MORE_MAX_HEIGHT,
  render,
  rowItems,
  sourcererScopeId,
  scopeId
}) => {
  if (rowItems != null && rowItems.length > 0) {
    const draggables = rowItems.slice(0, displayCount).map((rowItem, index) => {
      const id = (0, _helpers.escapeDataProviderId)(`default-field-renderer-default-draggable-${idPrefix}-${attrName}-${rowItem}`);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: id,
        grow: false
      }, index !== 0 && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ',', /*#__PURE__*/_react.default.createElement(_page.Spacer, null)), typeof rowItem === 'string' && /*#__PURE__*/_react.default.createElement(_draggables.DefaultDraggable, {
        id: id,
        isDraggable: isDraggable,
        field: attrName,
        value: rowItem,
        isAggregatable: true,
        fieldType: 'keyword',
        scopeId: scopeId
      }, render ? render(rowItem) : rowItem));
    });
    return draggables.length > 0 ? /*#__PURE__*/_react.default.createElement(DraggableContainerFlexGroup, {
      alignItems: "center",
      gutterSize: "none",
      component: "span",
      "data-test-subj": "DefaultFieldRendererComponent"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, draggables, " "), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(DefaultFieldRendererOverflow, {
      attrName: attrName,
      idPrefix: idPrefix,
      moreMaxHeight: moreMaxHeight,
      overflowIndexStart: displayCount,
      render: render,
      rowItems: rowItems,
      sourcererScopeId: sourcererScopeId
    }))) : (0, _empty_value.getEmptyTagValue)();
  } else {
    return (0, _empty_value.getEmptyTagValue)();
  }
};
exports.DefaultFieldRendererComponent = DefaultFieldRendererComponent;
const DefaultFieldRenderer = exports.DefaultFieldRenderer = /*#__PURE__*/_react.default.memo(DefaultFieldRendererComponent);
DefaultFieldRenderer.displayName = 'DefaultFieldRenderer';
const MoreContainer = exports.MoreContainer = /*#__PURE__*/_react.default.memo(({
  fieldName,
  idPrefix,
  moreMaxHeight,
  overflowIndexStart,
  render,
  values,
  sourcererScopeId
}) => {
  const {
    timelineId
  } = (0, _react.useContext)(_timeline.TimelineContext);
  const moreItemsWithHoverActions = (0, _react.useMemo)(() => values.slice(overflowIndexStart).reduce((acc, value, index) => {
    const id = (0, _helpers.escapeDataProviderId)(`${idPrefix}-${fieldName}-${value}-${index}`);
    if (typeof value === 'string' && fieldName != null) {
      acc.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        key: id
      }, /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
        key: id,
        mode: _cell_actions.CellActionsMode.HOVER_DOWN,
        visibleCellActions: 5,
        showActionTooltips: true,
        triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
        data: {
          value,
          field: fieldName
        },
        sourcererScopeId: sourcererScopeId !== null && sourcererScopeId !== void 0 ? sourcererScopeId : _model.SourcererScopeName.default,
        metadata: {
          scopeId: timelineId !== null && timelineId !== void 0 ? timelineId : undefined
        }
      }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, render ? render(value) : (0, _empty_value.defaultToEmptyTag)(value)))));
    }
    return acc;
  }, []), [values, overflowIndexStart, idPrefix, fieldName, timelineId, render, sourcererScopeId]);
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "more-container",
    className: "eui-yScroll",
    style: {
      maxHeight: moreMaxHeight,
      paddingRight: '2px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    "data-test-subj": "overflow-items"
  }, moreItemsWithHoverActions));
});
MoreContainer.displayName = 'MoreContainer';
const DefaultFieldRendererOverflow = exports.DefaultFieldRendererOverflow = /*#__PURE__*/_react.default.memo(({
  attrName,
  idPrefix,
  moreMaxHeight,
  overflowIndexStart = 5,
  render,
  rowItems,
  sourcererScopeId
}) => {
  const [isOpen, setIsOpen] = (0, _react.useState)(false);
  const togglePopover = (0, _react.useCallback)(() => setIsOpen(currentIsOpen => !currentIsOpen), []);
  const button = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, ' ,', /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    size: "xs",
    onClick: togglePopover,
    "data-test-subj": "DefaultFieldRendererOverflow-button"
  }, `+${rowItems.length - overflowIndexStart} `, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.fieldRenderers.moreLabel",
    defaultMessage: "More"
  }))), [togglePopover, overflowIndexStart, rowItems.length]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, rowItems.length > overflowIndexStart && /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    id: "popover",
    button: button,
    isOpen: isOpen,
    closePopover: togglePopover,
    repositionOnScroll: true,
    panelClassName: "withHoverActions__popover"
  }, /*#__PURE__*/_react.default.createElement(MoreContainer, {
    fieldName: attrName,
    idPrefix: idPrefix,
    render: render,
    values: rowItems,
    moreMaxHeight: moreMaxHeight,
    overflowIndexStart: overflowIndexStart,
    sourcererScopeId: sourcererScopeId
  })));
});
DefaultFieldRendererOverflow.displayName = 'DefaultFieldRendererOverflow';