"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimelineBottomBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _reactRedux = require("react-redux");
var i18n = _interopRequireWildcard(require("./translations"));
var _selectors = require("../../store/selectors");
var _add_timeline_button = require("./add_timeline_button");
var _store = require("../../store");
var _save_status = require("../save_status");
var _add_to_favorites = require("../add_to_favorites");
var _use_timeline_events_count = require("../../../common/hooks/use_timeline_events_count");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This component renders the bottom bar for timeline displayed or most of the pages within Security Solution.
 */
const TimelineBottomBar = exports.TimelineBottomBar = /*#__PURE__*/_react.default.memo(({
  show,
  timelineId,
  openToggleRef
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const openTimeline = (0, _react.useCallback)(() => dispatch(_store.timelineActions.showTimeline({
    id: timelineId,
    show: true
  })), [dispatch, timelineId]);
  const title = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTitleByTimelineById)(state, timelineId));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    borderRadius: "none",
    "data-test-subj": "timeline-bottom-bar"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "xs",
    alignItems: "center",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_timeline_button.AddTimelineButton, {
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_add_to_favorites.AddToFavoritesButton, {
    timelineId: timelineId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "aria-label": i18n.OPEN_TIMELINE_BUTTON(title),
    onClick: openTimeline,
    "data-test-subj": "timeline-bottom-bar-title-button",
    ref: openToggleRef
  }, title)), !show &&
  /*#__PURE__*/
  // this is a hack because TimelineEventsCountBadge is using react-reverse-portal so the component which is used in multiple places cannot be visible in multiple places at the same time
  _react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    "data-test-subj": "timeline-event-count-badge"
  }, /*#__PURE__*/_react.default.createElement(_use_timeline_events_count.TimelineEventsCountBadge, null)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_save_status.TimelineSaveStatus, {
    timelineId: timelineId
  }))));
});
TimelineBottomBar.displayName = 'TimelineBottomBar';