"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddToFavoritesButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _selectors = require("../../store/selectors");
var _store = require("../../store");
var _timeline = require("../../../../common/api/timeline");
var _step_config = require("../timeline/tour/step_config");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_FAVORITES = _i18n.i18n.translate('xpack.securitySolution.timeline.addToFavoriteButtonLabel', {
  defaultMessage: 'Add to favorites'
});
const REMOVE_FROM_FAVORITES = _i18n.i18n.translate('xpack.securitySolution.timeline.removeFromFavoritesButtonLabel', {
  defaultMessage: 'Remove from favorites'
});
/**
 * This component renders the add to favorites button for timeline.
 * It is used in the bottom bar as well as in the timeline modal's header.
 */
const AddToFavoritesButton = exports.AddToFavoritesButton = /*#__PURE__*/_react.default.memo(({
  timelineId,
  isPartOfGuidedTour = false
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isFavorite,
    status
  } = (0, _reactRedux.useSelector)(state => (0, _selectors.selectTimelineById)(state, timelineId));
  const isTimelineDraftOrImmutable = status !== _timeline.TimelineStatus.active;
  const label = isFavorite ? REMOVE_FROM_FAVORITES : ADD_TO_FAVORITES;
  const handleClick = (0, _react.useCallback)(() => dispatch(_store.timelineActions.updateIsFavorite({
    id: timelineId,
    isFavorite: !isFavorite
  })), [dispatch, timelineId, isFavorite]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    id: isPartOfGuidedTour ? _step_config.TIMELINE_TOUR_CONFIG_ANCHORS.ADD_TO_FAVORITES : undefined,
    iconType: isFavorite ? 'starFilled' : 'starEmpty',
    isSelected: isFavorite,
    disabled: isTimelineDraftOrImmutable,
    "aria-label": label,
    title: label,
    "data-test-subj": `timeline-favorite-${isFavorite ? 'filled' : 'empty'}-star`,
    onClick: handleClick
  }, label);
});
AddToFavoritesButton.displayName = 'AddToFavoritesButton';