"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.hasAtLeastOneValidRouteEntry = exports.allRouteEntriesArePaired = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const hasAtLeastOneValidRouteEntry = routeEntries => {
  return routeEntries.some(re => {
    const hasCriblDataId = re.dataId && re.dataId.length > 0;
    const hasDatastreamTarget = re.datastream && re.datastream.length > 0;
    return hasCriblDataId && hasDatastreamTarget;
  });
};
exports.hasAtLeastOneValidRouteEntry = hasAtLeastOneValidRouteEntry;
const allRouteEntriesArePaired = routeEntries => {
  return routeEntries.every(re => {
    const hasCriblDataId = re.dataId && re.dataId.length > 0;
    const hasDatastreamTarget = re.datastream && re.datastream.length > 0;
    return hasCriblDataId && hasDatastreamTarget || !hasCriblDataId && !hasDatastreamTarget;
  });
};
exports.allRouteEntriesArePaired = allRouteEntriesArePaired;