"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.routes = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public = require("@kbn/usage-collection-plugin/public");
var i18n = _interopRequireWildcard(require("./translations"));
var _constants = require("../../common/constants");
var _ = require("../app/404");
var _rule_management = require("../detection_engine/rule_management_ui/pages/rule_management");
var _rule_creation = require("../detection_engine/rule_creation_ui/pages/rule_creation");
var _rule_details = require("../detection_engine/rule_details_ui/pages/rule_details");
var _rule_editing = require("../detection_engine/rule_creation_ui/pages/rule_editing");
var _use_readonly_header = require("../use_readonly_header");
var _plugin_template_wrapper = require("../common/components/plugin_template_wrapper");
var _spy_routes = require("../common/utils/route/spy_routes");
var _rules_table_toolbar = require("../detection_engine/rule_management_ui/components/rules_table/rules_table_toolbar");
var _add_rules = require("../detection_engine/rule_management_ui/pages/add_rules");
var _landing = require("./landing");
var _coverage_overview = require("../detection_engine/rule_management_ui/pages/coverage_overview");
var _use_rule_details_tabs = require("../detection_engine/rule_details_ui/pages/rule_details/use_rule_details_tabs");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RulesSubRoutes = [{
  path: '/rules/id/:detailName/edit',
  main: _rule_editing.EditRulePage,
  exact: true
}, {
  path: `/rules/id/:detailName/:tabName(${_use_rule_details_tabs.RuleDetailTabs.alerts}|${_use_rule_details_tabs.RuleDetailTabs.exceptions}|${_use_rule_details_tabs.RuleDetailTabs.endpointExceptions}|${_use_rule_details_tabs.RuleDetailTabs.executionResults}|${_use_rule_details_tabs.RuleDetailTabs.executionEvents})`,
  main: _rule_details.RuleDetailsPage,
  exact: true
}, {
  path: '/rules/create',
  main: _rule_creation.CreateRulePage,
  exact: true
}, {
  path: `/rules/:tabName(${_rules_table_toolbar.AllRulesTabs.management}|${_rules_table_toolbar.AllRulesTabs.monitoring}|${_rules_table_toolbar.AllRulesTabs.updates})`,
  main: _rule_management.RulesPage,
  exact: true
}, {
  path: '/rules/add_rules',
  main: _add_rules.AddRulesPage,
  exact: true
}];
const RulesContainerComponent = () => {
  (0, _use_readonly_header.useReadonlyHeader)(i18n.READ_ONLY_BADGE_TOOLTIP);
  return /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
    viewId: _constants.SecurityPageName.rules
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route // Redirect to first tab if none specified
  , {
    path: "/rules/id/:detailName",
    exact: true,
    render: ({
      match: {
        params: {
          detailName
        }
      },
      location
    }) => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
      to: {
        ...location,
        pathname: `/rules/id/${detailName}/${_use_rule_details_tabs.RuleDetailTabs.alerts}`,
        search: location.search
      }
    })
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    path: "/rules",
    exact: true
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
    to: `/rules/${_rules_table_toolbar.AllRulesTabs.management}`
  })), RulesSubRoutes.map(route => {
    var _route$exact;
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      key: `rules-route-${route.path}`,
      path: route.path,
      exact: (_route$exact = route === null || route === void 0 ? void 0 : route.exact) !== null && _route$exact !== void 0 ? _route$exact : false
    }, /*#__PURE__*/_react.default.createElement(route.main, null));
  }), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
    component: _.NotFoundPage
  }), /*#__PURE__*/_react.default.createElement(_spy_routes.SpyRoute, {
    pageName: _constants.SecurityPageName.rules
  }))));
};
const Rules = /*#__PURE__*/_react.default.memo(RulesContainerComponent);
const CoverageOverviewRoutes = () => /*#__PURE__*/_react.default.createElement(_plugin_template_wrapper.PluginTemplateWrapper, null, /*#__PURE__*/_react.default.createElement(_public.TrackApplicationView, {
  viewId: _constants.SecurityPageName.coverageOverview
}, /*#__PURE__*/_react.default.createElement(_coverage_overview.CoverageOverviewPage, null)));
const routes = exports.routes = [{
  path: _constants.RULES_LANDING_PATH,
  component: _landing.RulesLandingPage
}, {
  path: _constants.RULES_PATH,
  component: Rules
}, {
  path: _constants.COVERAGE_OVERVIEW_PATH,
  component: CoverageOverviewRoutes
}];