"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResolverWithoutProviders = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _use_resolver_query_params_cleaner = require("./use_resolver_query_params_cleaner");
var selectors = _interopRequireWildcard(require("../store/selectors"));
var _edge_line = require("./edge_line");
var _controls = require("./controls");
var _process_event_dot = require("./process_event_dot");
var _use_camera = require("./use_camera");
var _symbol_definitions = require("./symbol_definitions");
var _use_state_syncing_actions = require("./use_state_syncing_actions");
var _styles = require("./styles");
var nodeModel = _interopRequireWildcard(require("../../../common/endpoint/models/node"));
var _side_effect_context = require("./side_effect_context");
var _panels = require("./panels");
var _use_colors = require("./use_colors");
var _use_sync_selected_node = require("./use_sync_selected_node");
var _resolver_no_process_events = require("./resolver_no_process_events");
var _use_autotune_timerange = require("./use_autotune_timerange");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * The highest level connected Resolver component. Needs a `Provider` in its ancestry to work.
 */
const ResolverWithoutProviders = exports.ResolverWithoutProviders = /*#__PURE__*/_react.default.memo(
/*#__PURE__*/
/**
 * Use `forwardRef` so that the `Simulator` used in testing can access the top level DOM element.
 */
_react.default.forwardRef(function ({
  className,
  databaseDocumentID,
  resolverComponentInstanceID,
  indices,
  shouldUpdate,
  filters
}, refToForward) {
  (0, _use_resolver_query_params_cleaner.useResolverQueryParamCleaner)(resolverComponentInstanceID);
  /**
   * This is responsible for dispatching actions that include any external data.
   * `databaseDocumentID`
   */
  (0, _use_state_syncing_actions.useStateSyncingActions)({
    databaseDocumentID,
    resolverComponentInstanceID,
    indices,
    shouldUpdate,
    filters
  });
  (0, _use_autotune_timerange.useAutotuneTimerange)({
    id: resolverComponentInstanceID
  });
  /**
   * This will keep the selectedNode in the view in sync with the nodeID specified in the url
   */
  (0, _use_sync_selected_node.useSyncSelectedNode)({
    id: resolverComponentInstanceID
  });
  const {
    timestamp
  } = (0, _react.useContext)(_side_effect_context.SideEffectContext);

  // use this for the entire render in order to keep things in sync
  const timeAtRender = timestamp();
  const {
    processNodePositions,
    connectingEdgeLineSegments
  } = (0, _reactRedux.useSelector)(state => selectors.visibleNodesAndEdgeLines(state.analyzer[resolverComponentInstanceID])(timeAtRender));
  const {
    projectionMatrix,
    ref: cameraRef,
    onMouseDown
  } = (0, _use_camera.useCamera)({
    id: resolverComponentInstanceID
  });
  const ref = (0, _react.useCallback)(element => {
    // Supply `useCamera` with the ref
    cameraRef(element);

    // If a ref is being forwarded, populate that as well.
    if (typeof refToForward === 'function') {
      refToForward(element);
    } else if (refToForward !== null) {
      refToForward.current = element;
    }
  }, [cameraRef, refToForward]);
  const isLoading = (0, _reactRedux.useSelector)(state => selectors.isTreeLoading(state.analyzer[resolverComponentInstanceID]));
  const hasError = (0, _reactRedux.useSelector)(state => selectors.hadErrorLoadingTree(state.analyzer[resolverComponentInstanceID]));
  const activeDescendantId = (0, _reactRedux.useSelector)(state => selectors.ariaActiveDescendant(state.analyzer[resolverComponentInstanceID]));
  const resolverTreeHasNodes = (0, _reactRedux.useSelector)(state => selectors.resolverTreeHasNodes(state.analyzer[resolverComponentInstanceID]));
  const colorMap = (0, _use_colors.useColors)();
  return /*#__PURE__*/_react.default.createElement(_styles.StyledMapContainer, {
    className: className,
    backgroundColor: colorMap.resolverBackground
  }, isLoading ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolver:graph:loading",
    className: "loading-container"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })) : hasError ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": "resolver:graph:error",
    className: "loading-container"
  }, /*#__PURE__*/_react.default.createElement("div", null, ' ', /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.resolver.loadingError",
    defaultMessage: "Error loading data."
  }))) : resolverTreeHasNodes ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_styles.GraphContainer, {
    "data-test-subj": "resolver:graph",
    className: "resolver-graph kbn-resetFocusState",
    onMouseDown: onMouseDown,
    ref: ref,
    role: "tree",
    tabIndex: 0,
    "aria-activedescendant": activeDescendantId || undefined
  }, connectingEdgeLineSegments.map(({
    points: [startPosition, endPosition],
    metadata
  }) => /*#__PURE__*/_react.default.createElement(_edge_line.EdgeLine, {
    edgeLineMetadata: metadata,
    key: metadata.reactKey,
    startPosition: startPosition,
    endPosition: endPosition,
    projectionMatrix: projectionMatrix
  })), [...processNodePositions].map(([treeNode, position]) => {
    const nodeID = nodeModel.nodeID(treeNode);
    if (nodeID === undefined) {
      throw new Error('Tried to render a node without an ID');
    }
    return /*#__PURE__*/_react.default.createElement(_process_event_dot.ProcessEventDot, {
      id: resolverComponentInstanceID,
      key: nodeID,
      nodeID: nodeID,
      position: position,
      projectionMatrix: projectionMatrix,
      node: treeNode,
      timeAtRender: timeAtRender
    });
  })), /*#__PURE__*/_react.default.createElement(_panels.PanelRouter, {
    id: resolverComponentInstanceID
  })) : /*#__PURE__*/_react.default.createElement(_resolver_no_process_events.ResolverNoProcessEvents, null), /*#__PURE__*/_react.default.createElement(_controls.GraphControls, {
    id: resolverComponentInstanceID
  }), /*#__PURE__*/_react.default.createElement(_symbol_definitions.SymbolDefinitions, {
    id: resolverComponentInstanceID
  }));
}));