"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeList = void 0;
var _reactRedux = require("react-redux");
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _side_effect_context = require("../side_effect_context");
var _styles = require("../styles");
var _styles2 = require("./styles");
var nodeModel = _interopRequireWildcard(require("../../../../common/endpoint/models/node"));
var selectors = _interopRequireWildcard(require("../../store/selectors"));
var _breadcrumbs = require("./breadcrumbs");
var _cube_for_process = require("./cube_for_process");
var _limit_warnings = require("../limit_warnings");
var _use_link_props = require("../use_link_props");
var _use_colors = require("../use_colors");
var _use_formatted_date = require("./use_formatted_date");
var _actions = require("../../store/actions");
var _cell_actions = require("../../../common/components/cell_actions");
var _helpers = require("../../../helpers");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/* eslint-disable @elastic/eui/href-or-on-click */

/**
 * The "default" view for the panel: A list of all the processes currently in the graph.
 */
const NodeList = exports.NodeList = /*#__PURE__*/(0, _react.memo)(({
  id
}) => {
  const columns = (0, _react.useMemo)(() => [{
    field: 'name',
    name: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.processNameTitle', {
      defaultMessage: 'Process Name'
    }),
    sortable: true,
    truncateText: true,
    render(name, item) {
      return /*#__PURE__*/_react.default.createElement(NodeDetailLink, {
        id: id,
        name: name,
        nodeID: item.nodeID
      });
    }
  }, {
    field: 'timestamp',
    name: _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.timestampTitle', {
      defaultMessage: 'Timestamp'
    }),
    dataType: 'date',
    sortable: true,
    render(eventDate) {
      return /*#__PURE__*/_react.default.createElement(NodeDetailTimestamp, {
        eventDate: eventDate,
        id: id
      });
    }
  }], [id]);
  const processTableView = (0, _reactRedux.useSelector)((0, _react.useCallback)(state => {
    const {
      processNodePositions
    } = selectors.layout(state.analyzer[id]);
    const view = [];
    for (const treeNode of processNodePositions.keys()) {
      const name = nodeModel.nodeName(treeNode);
      const nodeID = nodeModel.nodeID(treeNode);
      if (nodeID !== undefined) {
        view.push({
          name,
          timestamp: nodeModel.nodeDataTimestamp(treeNode),
          nodeID
        });
      }
    }
    return view;
  }, [id]));
  const numberOfProcesses = processTableView.length;
  const breadcrumbs = (0, _react.useMemo)(() => {
    return [{
      text: _i18n.i18n.translate('xpack.securitySolution.resolver.panel.nodeList.title', {
        defaultMessage: 'All Process Events'
      })
    }];
  }, []);
  const children = (0, _reactRedux.useSelector)(state => selectors.hasMoreChildren(state.analyzer[id]));
  const ancestors = (0, _reactRedux.useSelector)(state => selectors.hasMoreAncestors(state.analyzer[id]));
  const generations = (0, _reactRedux.useSelector)(state => selectors.hasMoreGenerations(state.analyzer[id]));
  const showWarning = children === true || ancestors === true || generations === true;
  const rowProps = (0, _react.useMemo)(() => ({
    'data-test-subj': 'resolver:node-list:item'
  }), []);
  return /*#__PURE__*/_react.default.createElement(_styles.StyledPanel, {
    hasBorder: true
  }, /*#__PURE__*/_react.default.createElement(_breadcrumbs.Breadcrumbs, {
    breadcrumbs: breadcrumbs
  }), showWarning && /*#__PURE__*/_react.default.createElement(_limit_warnings.LimitWarning, {
    numberDisplayed: numberOfProcesses
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    rowProps: rowProps,
    "data-test-subj": "resolver:node-list",
    items: processTableView,
    columns: columns,
    sorting: true
  }));
});
NodeList.displayName = 'NodeList';
const NodeDetailLink = /*#__PURE__*/(0, _react.memo)(({
  id,
  name,
  nodeID
}) => {
  const isOrigin = (0, _reactRedux.useSelector)(state => {
    return selectors.originID(state.analyzer[id]) === nodeID;
  });
  const nodeState = (0, _reactRedux.useSelector)(state => selectors.nodeDataStatus(state.analyzer[id])(nodeID));
  const {
    descriptionText
  } = (0, _use_colors.useColors)();
  const linkProps = (0, _use_link_props.useLinkProps)(id, {
    panelView: 'nodeDetail',
    panelParameters: {
      nodeID
    }
  });
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    timestamp
  } = (0, _react.useContext)(_side_effect_context.SideEffectContext);
  const handleOnClick = (0, _react.useCallback)(mouseEvent => {
    linkProps.onClick(mouseEvent);
    dispatch((0, _actions.userSelectedResolverNode)({
      id,
      nodeID,
      time: timestamp()
    }));
  }, [timestamp, linkProps, dispatch, nodeID, id]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    onClick: handleOnClick,
    href: linkProps.href,
    "data-test-subj": "resolver:node-list:node-link",
    "data-test-node-id": nodeID
  }, name === undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: "warning"
  }, _i18n.i18n.translate('xpack.securitySolution.endpoint.resolver.panel.table.row.valueMissingDescription', {
    defaultMessage: 'Value is missing'
  })) : /*#__PURE__*/_react.default.createElement(_styles2.StyledButtonTextContainer, null, /*#__PURE__*/_react.default.createElement(_cube_for_process.CubeForProcess, {
    id: id,
    state: nodeState,
    isOrigin: isOrigin,
    "data-test-subj": "resolver:node-list:node-link:icon"
  }), /*#__PURE__*/_react.default.createElement(_styles2.StyledLabelContainer, null, isOrigin && /*#__PURE__*/_react.default.createElement(_styles2.StyledAnalyzedEvent, {
    color: descriptionText,
    "data-test-subj": "resolver:node-list:node-link:analyzed-event"
  }, _i18n.i18n.translate('xpack.securitySolution.resolver.panel.table.row.analyzedEvent', {
    defaultMessage: 'ANALYZED EVENT'
  })), /*#__PURE__*/_react.default.createElement(_styles2.StyledLabelTitle, {
    "data-test-subj": "resolver:node-list:node-link:title"
  }, name))));
});
NodeDetailLink.displayName = 'NodeDetailLink';
const NodeDetailTimestamp = /*#__PURE__*/(0, _react.memo)(({
  eventDate,
  id
}) => {
  const formattedDate = (0, _use_formatted_date.useFormattedDate)(eventDate);
  return formattedDate ? /*#__PURE__*/_react.default.createElement(_cell_actions.SecurityCellActions, {
    data: {
      field: '@timestamp',
      value: eventDate
    },
    triggerId: _cell_actions.SecurityCellActionsTrigger.DEFAULT,
    visibleCellActions: 5,
    mode: _cell_actions.CellActionsMode.HOVER_DOWN,
    sourcererScopeId: (0, _helpers.getSourcererScopeId)(id),
    metadata: {
      scopeId: id
    }
  }, formattedDate) : /*#__PURE__*/_react.default.createElement("span", null, '—');
});
NodeDetailTimestamp.displayName = 'NodeDetailTimestamp';