"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SourcererButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _styles = require("./styles");
var _use_colors = require("../use_colors");
var _sourcerer = require("../../../common/components/sourcerer");
var _model = require("../../../common/store/sourcerer/model");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const nodeLegendButtonTitle = _i18n.i18n.translate('xpack.securitySolution.resolver.graphControls.sourcererButtonTitle', {
  defaultMessage: 'Data View Selection'
});
const SourcererButton = exports.SourcererButton = /*#__PURE__*/(0, _react.memo)(({
  id,
  closePopover,
  setActivePopover,
  isOpen
}) => {
  const setAsActivePopover = (0, _react.useCallback)(() => setActivePopover('sourcererSelection'), [setActivePopover]);
  const colorMap = (0, _use_colors.useColors)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: /*#__PURE__*/_react.default.createElement(_styles.StyledEuiButtonIcon, {
      "data-test-subj": "resolver:graph-controls:sourcerer-button",
      size: "m",
      title: nodeLegendButtonTitle,
      "aria-label": nodeLegendButtonTitle,
      onClick: setAsActivePopover,
      iconType: "indexSettings",
      $backgroundColor: colorMap.graphControlsBackground,
      $iconColor: colorMap.graphControls,
      $borderColor: colorMap.graphControlsBorderColor
    }),
    isOpen: isOpen,
    closePopover: closePopover,
    anchorPosition: "leftCenter"
  }, /*#__PURE__*/_react.default.createElement(_sourcerer.Sourcerer, {
    scope: _model.SourcererScopeName.analyzer
  }));
});
SourcererButton.displayName = 'SourcererButton';