"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scaleToZoom = void 0;
var _scaling_constants = require("./scaling_constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Calculates the zoom factor (between 0 and 1) for a given scale value.
 */
const scaleToZoom = scale => {
  const delta = _scaling_constants.maximum - _scaling_constants.minimum;
  return Math.pow((scale - _scaling_constants.minimum) / delta, 1 / _scaling_constants.zoomCurveRate);
};
exports.scaleToZoom = scaleToZoom;