"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PluginServices = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/data-plugin/public");
var _public2 = require("@kbn/kibana-utils-plugin/public");
var _telemetry = require("./common/lib/telemetry");
var _services = require("./common/lib/kibana/services");
var _use_license = require("./common/hooks/use_license");
var _experimental_features_service = require("./common/experimental_features_service");
var _config_settings = require("../common/config_settings");
var _constants = require("../common/constants");
var _top_values_popover_service = require("./app/components/top_values_popover/top_values_popover_service");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class PluginServices {
  constructor(config, experimentalFeatures, contract, packageInfo) {
    var _this$config$offering;
    (0, _defineProperty2.default)(this, "telemetry", new _telemetry.TelemetryService());
    (0, _defineProperty2.default)(this, "queryService", new _public.QueryService());
    (0, _defineProperty2.default)(this, "storage", new _public2.Storage(localStorage));
    (0, _defineProperty2.default)(this, "sessionStorage", new _public2.Storage(sessionStorage));
    (0, _defineProperty2.default)(this, "configSettings", void 0);
    /**
     * For internal use. Specify which version of the Detection Rules fleet package to install
     * when upgrading rules. If not provided, the latest compatible package will be installed,
     * or if running from a dev environment or -SNAPSHOT build, the latest pre-release package
     * will be used (if fleet is available or not within an airgapped environment).
     *
     * Note: This is for `upgrade only`, which occurs by means of the `useUpgradeSecurityPackages`
     * hook when navigating to a Security Solution page. The package version specified in
     * `fleet_packages.json` in project root will always be installed first on Kibana start if
     * the package is not already installed.
     */
    (0, _defineProperty2.default)(this, "prebuiltRulesPackageVersion", void 0);
    (0, _defineProperty2.default)(this, "startCustomDataService", (query, data) => {
      // used for creating a custom stateful KQL Query Bar
      const customDataService = {
        ...data,
        query,
        // @ts-expect-error
        _name: 'custom'
      };

      // @ts-expect-error
      customDataService.query.filterManager._name = 'customFilterManager';
      return customDataService;
    });
    this.config = config;
    this.experimentalFeatures = experimentalFeatures;
    this.contract = contract;
    this.packageInfo = packageInfo;
    this.configSettings = (0, _config_settings.parseConfigSettings)((_this$config$offering = this.config.offeringSettings) !== null && _this$config$offering !== void 0 ? _this$config$offering : {}).settings;
    this.prebuiltRulesPackageVersion = this.config.prebuiltRulesPackageVersion;
  }
  setup(coreSetup, pluginsSetup) {
    var _this$queryService;
    (0, _telemetry.initTelemetry)({
      usageCollection: pluginsSetup.usageCollection
    }, _constants.APP_UI_ID);
    this.telemetry.setup({
      analytics: coreSetup.analytics
    }, {
      prebuiltRulesPackageVersion: this.prebuiltRulesPackageVersion
    });
    (_this$queryService = this.queryService) === null || _this$queryService === void 0 ? void 0 : _this$queryService.setup({
      uiSettings: coreSetup.uiSettings,
      storage: this.storage,
      nowProvider: new _public.NowProvider()
    });
  }
  start(coreStart, pluginsStart) {
    _experimental_features_service.ExperimentalFeaturesService.init({
      experimentalFeatures: this.experimentalFeatures
    });
    _use_license.licenseService.start(pluginsStart.licensing.license$);
    _services.KibanaServices.init({
      ...coreStart,
      ...pluginsStart,
      kibanaBranch: this.packageInfo.branch,
      kibanaVersion: this.packageInfo.version,
      buildFlavor: this.packageInfo.buildFlavor,
      prebuiltRulesPackageVersion: this.prebuiltRulesPackageVersion
    });
  }
  stop() {
    this.queryService.stop();
    _use_license.licenseService.stop();
  }
  async generateServices(coreStart, startPlugins, params) {
    const {
      apm
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('@elastic/apm-rum')));
    const {
      SecuritySolutionTemplateWrapper
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('./app/home/template_wrapper')));
    const {
      savedObjectsTaggingOss,
      ...plugins
    } = startPlugins;
    const query = this.queryService.start({
      uiSettings: coreStart.uiSettings,
      storage: this.storage,
      http: coreStart.http
    });
    const customDataService = this.startCustomDataService(query, startPlugins.data);
    return {
      ...coreStart,
      ...plugins,
      ...this.contract.getStartServices(),
      apm,
      configSettings: this.configSettings,
      savedObjectsTagging: savedObjectsTaggingOss.getTaggingApi(),
      ...(params !== null && params !== void 0 && params.setHeaderActionMenu ? {
        setHeaderActionMenu: params.setHeaderActionMenu
      } : {}),
      storage: this.storage,
      sessionStorage: this.sessionStorage,
      security: startPlugins.security,
      ...(params !== null && params !== void 0 && params.onAppLeave ? {
        onAppLeave: params.onAppLeave
      } : {}),
      securityLayout: {
        getPluginWrapper: () => SecuritySolutionTemplateWrapper
      },
      contentManagement: startPlugins.contentManagement,
      telemetry: this.telemetry.start(),
      customDataService,
      topValuesPopover: new _top_values_popover_service.TopValuesPopoverService(),
      timelineFilterManager: new _public.FilterManager(coreStart.uiSettings)
    };
  }
  getExperimentalFeatures() {
    return this.experimentalFeatures;
  }
}
exports.PluginServices = PluginServices;