"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WARM = exports.VIEW_EVENTS = exports.VIEW_ALERTS = exports.UNMANAGED = exports.TOP = exports.TECHNICAL_PREVIEW = exports.SECURITY_SOLUTION_DEFAULT_INDEX_TOOLTIP = exports.RECENT_TIMELINES = exports.NEWS_FEED_TITLE = exports.HOT = exports.FROZEN = exports.EVENTS = exports.ELASTIC_COMMON_SCHEMA = exports.DETECTION_RESPONSE_TITLE = exports.DATE_PICKER_TOOLTIP = exports.DATA_QUALITY_TITLE = exports.COLD = exports.BETA = exports.ALERT_TREND = exports.ADD_TO_CASE_SUCCESS = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ADD_TO_CASE_SUCCESS = exports.ADD_TO_CASE_SUCCESS = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.addToCaseSuccessToast', {
  defaultMessage: 'Successfully added data quality results to the case'
});
const BETA = exports.BETA = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.betaBadge', {
  defaultMessage: 'Beta'
});
const COLD = exports.COLD = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseCold', {
  defaultMessage: 'cold'
});
const DATA_QUALITY_TITLE = exports.DATA_QUALITY_TITLE = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.pageTitle', {
  defaultMessage: 'Data Quality'
});
const DATE_PICKER_TOOLTIP = exports.DATE_PICKER_TOOLTIP = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.datePicker.tooltip', {
  defaultMessage: `Data quality checks are ran on data that was ingested during the Search Boost window. The default window range is 7 days.`
});
const ELASTIC_COMMON_SCHEMA = exports.ELASTIC_COMMON_SCHEMA = _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.elasticCommonSchemaReferenceLink', {
  defaultMessage: 'Elastic Common Schema (ECS)'
});
const SECURITY_SOLUTION_DEFAULT_INDEX_TOOLTIP = settingName => _i18n.i18n.translate('xpack.securitySolution.dataQualityDashboard.securitySolutionDefaultIndexTooltip', {
  values: {
    settingName
  },
  defaultMessage: `Indices and patterns from the {settingName} setting`
});
exports.SECURITY_SOLUTION_DEFAULT_INDEX_TOOLTIP = SECURITY_SOLUTION_DEFAULT_INDEX_TOOLTIP;
const EVENTS = exports.EVENTS = _i18n.i18n.translate('xpack.securitySolution.overview.eventsTitle', {
  defaultMessage: 'Event count'
});
const FROZEN = exports.FROZEN = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseFrozen', {
  defaultMessage: 'frozen'
});
const HOT = exports.HOT = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseHot', {
  defaultMessage: 'hot'
});
const NEWS_FEED_TITLE = exports.NEWS_FEED_TITLE = _i18n.i18n.translate('xpack.securitySolution.overview.newsFeedSidebarTitle', {
  defaultMessage: 'Security news'
});
const RECENT_TIMELINES = exports.RECENT_TIMELINES = _i18n.i18n.translate('xpack.securitySolution.overview.recentTimelinesSidebarTitle', {
  defaultMessage: 'Recent timelines'
});
const ALERT_TREND = exports.ALERT_TREND = _i18n.i18n.translate('xpack.securitySolution.overview.signalCountTitle', {
  defaultMessage: 'Alert trend'
});
const TOP = fieldName => _i18n.i18n.translate('xpack.securitySolution.overview.topNLabel', {
  values: {
    fieldName
  },
  defaultMessage: `Top {fieldName}`
});
exports.TOP = TOP;
const UNMANAGED = exports.UNMANAGED = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseUnmanaged', {
  defaultMessage: 'unmanaged'
});
const VIEW_ALERTS = exports.VIEW_ALERTS = _i18n.i18n.translate('xpack.securitySolution.overview.viewAlertsButtonLabel', {
  defaultMessage: 'View alerts'
});
const VIEW_EVENTS = exports.VIEW_EVENTS = _i18n.i18n.translate('xpack.securitySolution.overview.viewEventsButtonLabel', {
  defaultMessage: 'View events'
});
const WARM = exports.WARM = _i18n.i18n.translate('xpack.securitySolution.overview.ilmPhaseWarm', {
  defaultMessage: 'warm'
});
const DETECTION_RESPONSE_TITLE = exports.DETECTION_RESPONSE_TITLE = _i18n.i18n.translate('xpack.securitySolution.detectionResponse.pageTitle', {
  defaultMessage: 'Detection & Response'
});
const TECHNICAL_PREVIEW = exports.TECHNICAL_PREVIEW = _i18n.i18n.translate('xpack.securitySolution.entityAnalytics.technicalPreviewLabel', {
  defaultMessage: 'Technical Preview'
});