"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UserOverview = void 0;
var _eui = require("@elastic/eui");
var _uiTheme = require("@kbn/ui-theme");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _use_risk_score = require("../../../entity_analytics/api/hooks/use_risk_score");
var _search_strategy = require("../../../../common/search_strategy");
var _kibana = require("../../../common/lib/kibana");
var _empty_value = require("../../../common/components/empty_value");
var _field_renderers = require("../../../timelines/components/field_renderers/field_renderers");
var _first_last_seen = require("../../../common/components/first_last_seen/first_last_seen");
var _inspect = require("../../../common/components/inspect");
var _loader = require("../../../common/components/loader");
var _links = require("../../../common/components/links");
var _has_ml_user_permissions = require("../../../../common/machine_learning/has_ml_user_permissions");
var _use_ml_capabilities = require("../../../common/components/ml/hooks/use_ml_capabilities");
var _anomaly_scores = require("../../../common/components/ml/score/anomaly_scores");
var _page = require("../../../common/components/page");
var i18n = _interopRequireWildcard(require("./translations"));
var _overview_description_list = require("../../../common/components/overview_description_list");
var _common = require("../../../entity_analytics/components/severity/common");
var _risk_score_header_title = require("../../../entity_analytics/components/risk_score_onboarding/risk_score_header_title");
var _common2 = require("../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const UserRiskOverviewWrapper = (0, _styledComponents.default)(_eui.EuiFlexGroup)`
  padding-top: ${({
  theme
}) => theme.eui.euiSizeM};
  width: ${({
  $width
}) => $width};
`;
const UserOverview = exports.UserOverview = /*#__PURE__*/_react.default.memo(({
  anomaliesData,
  contextID,
  sourcererScopeId,
  data,
  id,
  isDraggable = false,
  isInDetailsSidePanel = false,
  // Rather than duplicate the component, alter the structure based on it's location
  isLoadingAnomaliesData,
  loading,
  narrowDateRange,
  startDate,
  endDate,
  userName,
  indexPatterns,
  jobNameById
}) => {
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const userPermissions = (0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities);
  const darkMode = (0, _kibana.useDarkMode)();
  const filterQuery = (0, _react.useMemo)(() => userName ? (0, _search_strategy.buildUserNamesFilter)([userName]) : undefined, [userName]);
  const {
    data: userRisk,
    isAuthorized
  } = (0, _use_risk_score.useRiskScore)({
    filterQuery,
    skip: userName == null,
    riskEntity: _search_strategy.RiskScoreEntity.user
  });
  const getDefaultRenderer = (0, _react.useCallback)((fieldName, fieldData) => /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
    rowItems: (0, _fp.getOr)([], fieldName, fieldData),
    attrName: fieldName,
    idPrefix: contextID ? `user-overview-${contextID}` : 'user-overview',
    isDraggable: isDraggable,
    sourcererScopeId: sourcererScopeId
  }), [contextID, isDraggable, sourcererScopeId]);
  const [userRiskScore, userRiskLevel] = (0, _react.useMemo)(() => {
    const userRiskData = userRisk && userRisk.length > 0 ? userRisk[0] : undefined;
    return [{
      title: /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
        title: i18n.USER_RISK_SCORE,
        riskScoreEntity: _search_strategy.RiskScoreEntity.user
      }),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userRiskData ? Math.round(userRiskData.user.risk.calculated_score_norm) : (0, _empty_value.getEmptyTagValue)())
    }, {
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "flexEnd",
        gutterSize: "none"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_risk_score_header_title.RiskScoreHeaderTitle, {
        title: i18n.USER_RISK_LEVEL,
        riskScoreEntity: _search_strategy.RiskScoreEntity.user
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_common2.RiskScoreDocTooltip, {
        riskScoreEntity: _search_strategy.RiskScoreEntity.user
      }))),
      description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, userRiskData ? /*#__PURE__*/_react.default.createElement(_common.RiskScoreLevel, {
        severity: userRiskData.user.risk.calculated_level,
        hideBackgroundColor: true
      }) : (0, _empty_value.getEmptyTagValue)())
    }];
  }, [userRisk]);
  const column = (0, _react.useMemo)(() => [{
    title: i18n.USER_ID,
    description: data && data.user ? getDefaultRenderer('user.id', data) : (0, _empty_value.getEmptyTagValue)()
  }, {
    title: i18n.USER_DOMAIN,
    description: data && data.user ? getDefaultRenderer('user.domain', data) : (0, _empty_value.getEmptyTagValue)()
  }], [data, getDefaultRenderer]);
  const firstColumn = (0, _react.useMemo)(() => userPermissions ? [...column, {
    title: i18n.MAX_ANOMALY_SCORE_BY_JOB,
    description: /*#__PURE__*/_react.default.createElement(_anomaly_scores.AnomalyScores, {
      anomalies: anomaliesData,
      startDate: startDate,
      endDate: endDate,
      isLoading: isLoadingAnomaliesData,
      narrowDateRange: narrowDateRange,
      jobNameById: jobNameById
    })
  }] : column, [anomaliesData, column, endDate, isLoadingAnomaliesData, narrowDateRange, startDate, userPermissions, jobNameById]);
  const descriptionLists = (0, _react.useMemo)(() => [firstColumn, [{
    title: i18n.FIRST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexPatterns,
      field: 'user.name',
      value: userName,
      type: _first_last_seen.FirstLastSeenType.FIRST_SEEN
    })
  }, {
    title: i18n.LAST_SEEN,
    description: /*#__PURE__*/_react.default.createElement(_first_last_seen.FirstLastSeen, {
      indexPatterns: indexPatterns,
      field: 'user.name',
      value: userName,
      type: _first_last_seen.FirstLastSeenType.LAST_SEEN
    })
  }], [{
    title: i18n.HOST_OS,
    description: getDefaultRenderer('host.os.name', data)
  }, {
    title: i18n.HOST_FAMILY,
    description: getDefaultRenderer('host.os.family', data)
  }, {
    title: i18n.HOST_IP,
    description: /*#__PURE__*/_react.default.createElement(_field_renderers.DefaultFieldRenderer, {
      rowItems: (0, _fp.getOr)([], 'host.ip', data),
      attrName: 'host.ip',
      idPrefix: contextID ? `user-overview-${contextID}` : 'user-overview',
      sourcererScopeId: sourcererScopeId,
      isDraggable: isDraggable,
      render: ip => ip != null ? /*#__PURE__*/_react.default.createElement(_links.NetworkDetailsLink, {
        ip: ip
      }) : (0, _empty_value.getEmptyTagValue)()
    })
  }]], [data, indexPatterns, getDefaultRenderer, contextID, sourcererScopeId, isDraggable, userName, firstColumn]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inspect.InspectButtonContainer, null, /*#__PURE__*/_react.default.createElement(_page.OverviewWrapper, {
    direction: isInDetailsSidePanel ? 'column' : 'row',
    "data-test-subj": "user-overview"
  }, !isInDetailsSidePanel && /*#__PURE__*/_react.default.createElement(_inspect.InspectButton, {
    queryId: id,
    title: i18n.INSPECT_TITLE,
    inspectIndex: 0
  }), descriptionLists.map((descriptionList, index) => /*#__PURE__*/_react.default.createElement(_overview_description_list.OverviewDescriptionList, {
    descriptionList: descriptionList,
    key: index
  })), loading && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
    overlay: true,
    overlayBackground: darkMode ? _uiTheme.euiDarkVars.euiPageBackgroundColor : _uiTheme.euiLightVars.euiPageBackgroundColor,
    size: "xl"
  }))), isAuthorized && /*#__PURE__*/_react.default.createElement(UserRiskOverviewWrapper, {
    gutterSize: isInDetailsSidePanel ? 'm' : 'none',
    direction: isInDetailsSidePanel ? 'column' : 'row',
    "data-test-subj": "user-risk-overview",
    $width: isInDetailsSidePanel ? '100%' : '66.6%'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    listItems: [userRiskScore]
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_page.DescriptionListStyled, {
    listItems: [userRiskLevel]
  }))));
});
UserOverview.displayName = 'UserOverview';