"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ProtectionUpdatesLayout = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _styledComponents = require("styled-components");
var _i18n = require("@kbn/i18n");
var _moment = _interopRequireDefault(require("moment"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _use_get_protection_updates_unavailable_component = require("./hooks/use_get_protection_updates_unavailable_component");
var _protection_updates_bottom_bar = require("./components/protection_updates_bottom_bar");
var _use_post_protection_updates_note = require("./hooks/use_post_protection_updates_note");
var _use_get_protection_updates_note = require("./hooks/use_get_protection_updates_note");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _kibana = require("../../../../../common/lib/kibana");
var _use_update_endpoint_policy = require("../../../../hooks/policy/use_update_endpoint_policy");
var _protection_updates_warning_panel = require("./components/protection_updates_warning_panel");
var _controlled_artifact_rollout = require("../../../../../../common/endpoint/utils/controlled_artifact_rollout");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AUTOMATIC_UPDATES_CHECKBOX_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.useAutomaticUpdates', {
  defaultMessage: 'Automatic updates enabled'
});
const AUTOMATIC_UPDATES_OFF_CHECKBOX_LABEL = _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.useAutomaticUpdatesOff', {
  defaultMessage: 'Automatic updates disabled.'
});
const ProtectionUpdatesLayout = exports.ProtectionUpdatesLayout = /*#__PURE__*/_react.default.memo(({
  policy: _policy,
  setUnsavedChanges
}) => {
  const toasts = (0, _kibana.useToasts)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    isLoading: isUpdating,
    mutateAsync: sendPolicyUpdate
  } = (0, _use_update_endpoint_policy.useUpdateEndpointPolicy)();
  const {
    canWritePolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    docLinks
  } = (0, _kibana.useKibana)().services;
  const paddingSize = (0, _react.useContext)(_styledComponents.ThemeContext).eui.euiPanelPaddingModifiers.paddingMedium;
  const policy = _policy;
  const deployedVersion = policy.inputs[0].config.policy.value.global_manifest_version;
  const [manifestVersion, setManifestVersion] = (0, _react.useState)(deployedVersion);
  const today = _moment.default.utc();
  const defaultDate = today.clone().subtract(1, 'days');
  const [selectedDate, setSelectedDate] = (0, _react.useState)(defaultDate);
  const {
    data: fetchedNote,
    isLoading: getNoteInProgress
  } = (0, _use_get_protection_updates_note.useGetProtectionUpdatesNote)({
    packagePolicyId: _policy.id
  });
  const {
    isLoading: createNoteInProgress,
    mutate: createNote
  } = (0, _use_post_protection_updates_note.useCreateProtectionUpdatesNote)({
    packagePolicyId: _policy.id
  });
  const [note, setNote] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    if (fetchedNote && !getNoteInProgress) {
      setNote(fetchedNote.note);
    }
  }, [fetchedNote, getNoteInProgress]);
  const automaticUpdatesEnabled = manifestVersion === 'latest';
  const internalDateFormat = 'YYYY-MM-DD';
  const displayDateFormat = 'MMMM DD, YYYY';
  const formattedDate = _moment.default.utc(deployedVersion, internalDateFormat).format(displayDateFormat);
  const cutoffDate = (0, _controlled_artifact_rollout.getControlledArtifactCutoffDate)(); // Earliest selectable date

  const viewModeSwitchLabel = automaticUpdatesEnabled ? AUTOMATIC_UPDATES_CHECKBOX_LABEL : AUTOMATIC_UPDATES_OFF_CHECKBOX_LABEL;
  const saveButtonEnabled = (fetchedNote ? note !== fetchedNote.note : note !== '') || manifestVersion !== deployedVersion;
  (0, _react.useEffect)(() => {
    setUnsavedChanges(saveButtonEnabled);
  }, [saveButtonEnabled, setUnsavedChanges]);
  const onSave = (0, _react.useCallback)(() => {
    const update = (0, _lodash.cloneDeep)(policy);
    update.inputs[0].config.policy.value.global_manifest_version = manifestVersion;
    sendPolicyUpdate({
      policy: update
    }).then(({
      item: policyItem
    }) => {
      toasts.addSuccess({
        'data-test-subj': 'protectionUpdatesSuccessfulMessage',
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.updateSuccessTitle', {
          defaultMessage: 'Success!'
        }),
        text: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.updateSuccessMessage', {
          defaultMessage: 'Manifest updates successfully saved'
        })
      });

      // Since the 'policyItem' is stored in a store and fetched as a result of an action on urlChange, we still need to dispatch an action even though Redux was removed from this component.
      dispatch({
        type: 'serverReturnedPolicyDetailsData',
        payload: {
          policyItem
        }
      });
    }).catch(err => {
      toasts.addDanger({
        'data-test-subj': 'protectionUpdatesFailureMessage',
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.updateErrorTitle', {
          defaultMessage: 'Failed!'
        }),
        text: err.message
      });
    });
    if (!fetchedNote && note !== '' || fetchedNote && note !== fetchedNote.note) {
      createNote({
        note
      }, {
        onError: error => {
          toasts.addDanger({
            'data-test-subj': 'protectionUpdatesNoteUpdateFailureMessage',
            title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.noteUpdateErrorTitle', {
              defaultMessage: 'Note update failed!'
            }),
            text: error.body.message
          });
        }
      });
    }
  }, [policy, manifestVersion, sendPolicyUpdate, fetchedNote, note, toasts, dispatch, createNote]);
  const toggleAutomaticUpdates = (0, _react.useCallback)(event => {
    const {
      checked
    } = event.target;
    if (checked && !automaticUpdatesEnabled) {
      setManifestVersion('latest');
      // Clear selected date on user enabling automatic updates
      if (selectedDate !== defaultDate) {
        setSelectedDate(defaultDate);
      }
    } else {
      setManifestVersion(selectedDate.format(internalDateFormat));
    }
  }, [automaticUpdatesEnabled, selectedDate, defaultDate]);
  const updateDatepickerSelectedDate = (0, _react.useCallback)(date => {
    if (date !== null && date !== void 0 && date.isAfter(cutoffDate) && date !== null && date !== void 0 && date.isSameOrBefore(defaultDate)) {
      setSelectedDate(date || defaultDate);
      setManifestVersion((date === null || date === void 0 ? void 0 : date.format(internalDateFormat)) || 'latest');
    }
  }, [cutoffDate, defaultDate]);
  const renderVersionToDeployPicker = () => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      "data-test-subj": 'protection-updates-manifest-name-version-to-deploy-title'
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.versionToDeploy.label', {
      defaultMessage: 'Version to deploy'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), canWritePolicyManagement ? /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": 'protection-updates-version-to-deploy-picker'
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, {
      popoverPlacement: 'downCenter',
      dateFormat: displayDateFormat,
      selected: selectedDate,
      maxDate: defaultDate,
      minDate: cutoffDate,
      onChange: updateDatepickerSelectedDate
    })) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      "data-test-subj": "protection-updates-version-to-deploy-view-mode"
    }, selectedDate.format(displayDateFormat)));
  };
  const renderManifestOutdatedCallOut = () => {
    if (automaticUpdatesEnabled || deployedVersion === 'latest') {
      return null;
    }
    const deployedVersionDate = _moment.default.utc(deployedVersion).format(internalDateFormat);
    const daysSinceLastUpdate = today.diff(deployedVersionDate, 'days');
    if (daysSinceLastUpdate < 30) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: 'warning',
      iconType: 'alert',
      size: "m",
      "data-test-subj": "protection-updates-manifest-outdated",
      title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.manifestOutdated.title', {
        defaultMessage: 'Manifest outdated'
      })
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.endpoint.protectionUpdates.manifestOutdated",
      defaultMessage: "Your protection artifacts have not been updated in over 30 days. We strongly recommend keeping these up to date to ensure the highest level of security for your environment.{break}Note: After 18 months, protection artifacts will expire and cannot be rolled back. {learnMore}",
      values: {
        learnMore: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: docLinks.links.securitySolution.artifactControl,
          target: "_blank",
          external: true
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.securitySolution.endpoint.protectionUpdates.manifestOutdated.learnMore",
          defaultMessage: "Learn more"
        })),
        break: /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
          size: "m"
        })
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  };
  const renderContent = () => {
    if (automaticUpdatesEnabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        color: 'primary',
        iconType: 'iInCircle',
        size: "m",
        "data-test-subj": "protection-updates-automatic-updates-enabled",
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.automaticUpdates.enabledTitle', {
          defaultMessage: 'Automatic updates enabled'
        })
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.protectionUpdates.automaticUpdates.enabled",
        defaultMessage: "Protection updates will always be updated to the latest available version. If you want to control updates manually, disable the {toggleName} toggle.",
        values: {
          toggleName: /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.automaticUpdates.enabled.toggleName', {
            defaultMessage: 'Enable automatic updates'
          }))
        }
      }));
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      "data-test-subj": 'protection-updates-manifest-name-deployed-version-title'
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.deployedVersion.label', {
      defaultMessage: 'Currently deployed version'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m",
      "data-test-subj": "protection-updates-deployed-version"
    }, deployedVersion === 'latest' ? 'latest' : formattedDate), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), renderVersionToDeployPicker(), (canWritePolicyManagement || note) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "none",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xxs",
      "data-test-subj": 'protection-updates-manifest-name-note-title'
    }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.note.label', {
      defaultMessage: 'Note'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      position: "right",
      content: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.protectionUpdates.note.tooltip",
        defaultMessage: "You can add an optional note to explain the reason for selecting a particular policy version."
      }))
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), canWritePolicyManagement ? /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
      value: note,
      disabled: getNoteInProgress || createNoteInProgress,
      onChange: e => setNote(e.target.value),
      fullWidth: true,
      rows: 3,
      placeholder: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.note.placeholder', {
        defaultMessage: 'Add relevant information about update here'
      }),
      "data-test-subj": 'protection-updates-manifest-note'
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      "data-test-subj": 'protection-updates-manifest-note-view-mode'
    }, note)));
  };
  const ProtectionUpdatesUpsellingComponent = (0, _use_get_protection_updates_unavailable_component.useGetProtectionUpdatesUnavailableComponent)();
  if (ProtectionUpdatesUpsellingComponent) {
    return /*#__PURE__*/_react.default.createElement(ProtectionUpdatesUpsellingComponent, null);
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    "data-test-subject": "protection-updates-layout",
    hasBorder: true,
    hasShadow: false,
    paddingSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "none",
    alignItems: "center",
    style: {
      padding: `${paddingSize} ${paddingSize} 0 ${paddingSize}`
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xxs",
    "data-test-subj": 'protection-updates-manifest-name-title'
  }, /*#__PURE__*/_react.default.createElement("h5", null, _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.title', {
    defaultMessage: 'Manage protection updates'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiShowFor, {
    sizes: ['l', 'xl', 'm']
  }, canWritePolicyManagement ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    disabled: isUpdating || createNoteInProgress || getNoteInProgress,
    label: _i18n.i18n.translate('xpack.securitySolution.endpoint.protectionUpdates.enableAutomaticUpdates', {
      defaultMessage: 'Enable automatic updates'
    }),
    labelProps: {
      'data-test-subj': 'protection-updates-manifest-switch-label'
    },
    checked: automaticUpdatesEnabled,
    onChange: toggleAutomaticUpdates,
    "data-test-subj": 'protection-updates-manifest-switch'
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": 'protection-updates-state-view-mode'
  }, viewModeSwitchLabel))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: `0 ${paddingSize} ${paddingSize} ${paddingSize}`
    }
  }, /*#__PURE__*/_react.default.createElement(_protection_updates_warning_panel.ProtectionUpdatesWarningPanel, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), renderManifestOutdatedCallOut(), renderContent())), /*#__PURE__*/_react.default.createElement(_protection_updates_bottom_bar.ProtectionUpdatesBottomBar, {
    isUpdating: isUpdating,
    saveButtonDisabled: !canWritePolicyManagement || !saveButtonEnabled,
    onSave: onSave
  }));
});
ProtectionUpdatesLayout.displayName = 'ProtectionUpdatesLayout';