"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicySettingsLayout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _user_privileges = require("../../../../../common/components/user_privileges");
var _use_fetch_endpoint_policy_agent_summary = require("../../../../hooks/policy/use_fetch_endpoint_policy_agent_summary");
var _use_update_endpoint_policy = require("../../../../hooks/policy/use_update_endpoint_policy");
var _policy_settings_form = require("../policy_settings_form");
var _kibana = require("../../../../../common/lib/kibana");
var _common = require("../../../../../../common");
var _routing = require("../../../../common/routing");
var _use_navigate_to_app_event_handler = require("../../../../../common/hooks/endpoint/use_navigate_to_app_event_handler");
var _policy_form_confirm_update = require("./components/policy_form_confirm_update");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicySettingsLayout = exports.PolicySettingsLayout = /*#__PURE__*/(0, _react.memo)(({
  policy: _policy,
  setUnsavedChanges
}) => {
  var _policy$name;
  const policy = _policy;
  const {
    services: {
      application: {
        navigateToApp
      }
    }
  } = (0, _kibana.useKibana)();
  const toasts = (0, _kibana.useToasts)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    state: locationRouteState
  } = (0, _reactRouterDom.useLocation)();
  const {
    canWritePolicyManagement
  } = (0, _user_privileges.useUserPrivileges)().endpointPrivileges;
  const {
    isLoading: isUpdating,
    mutateAsync: sendPolicyUpdate
  } = (0, _use_update_endpoint_policy.useUpdateEndpointPolicy)();
  const {
    data: agentSummaryData
  } = (0, _use_fetch_endpoint_policy_agent_summary.useFetchAgentByAgentPolicySummary)(policy.policy_id);
  const [policySettings, setPolicySettings] = (0, _react.useState)((0, _lodash.cloneDeep)(policy.inputs[0].config.policy.value));
  const [policyModified, setPolicyModified] = (0, _react.useState)(false);
  const [showConfirm, setShowConfirm] = (0, _react.useState)(false);
  const [routeState, setRouteState] = (0, _react.useState)();
  const isEditMode = canWritePolicyManagement;
  const policyName = (_policy$name = policy === null || policy === void 0 ? void 0 : policy.name) !== null && _policy$name !== void 0 ? _policy$name : '';
  const routingOnCancelNavigateTo = routeState === null || routeState === void 0 ? void 0 : routeState.onCancelNavigateTo;
  const navigateToAppArguments = (0, _react.useMemo)(() => {
    if (routingOnCancelNavigateTo) {
      return routingOnCancelNavigateTo;
    }
    return [_common.APP_UI_ID, {
      path: (0, _routing.getPoliciesPath)()
    }];
  }, [routingOnCancelNavigateTo]);
  const handleSettingsOnChange = (0, _react.useCallback)(updates => {
    setPolicySettings(updates.updatedPolicy);
    setPolicyModified(!(0, _lodash.isEqual)(updates.updatedPolicy, policy.inputs[0].config.policy.value));
  }, [policy.inputs]);
  const handleCancelOnClick = (0, _use_navigate_to_app_event_handler.useNavigateToAppEventHandler)(...navigateToAppArguments);
  const handleSaveOnClick = (0, _react.useCallback)(() => {
    setShowConfirm(true);
  }, []);
  const handleSaveCancel = (0, _react.useCallback)(() => {
    setShowConfirm(false);
  }, []);
  const handleSaveConfirmation = (0, _react.useCallback)(() => {
    const update = (0, _lodash.cloneDeep)(policy);
    update.inputs[0].config.policy.value = policySettings;
    sendPolicyUpdate({
      policy: update
    }).then(({
      item: policyItem
    }) => {
      toasts.addSuccess({
        'data-test-subj': 'policyDetailsSuccessMessage',
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateSuccessTitle', {
          defaultMessage: 'Success!'
        }),
        text: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateSuccessMessage', {
          defaultMessage: 'Integration {name} has been updated.',
          values: {
            name: policyName
          }
        })
      });
      if (routeState && routeState.onSaveNavigateTo) {
        navigateToApp(...routeState.onSaveNavigateTo);
      } else {
        setPolicyModified(false);
        // Since the 'policyItem' is stored in a store and fetched as a result of an action on urlChange, we still need to dispatch an action even though Redux was removed from this component.
        dispatch({
          type: 'serverReturnedPolicyDetailsData',
          payload: {
            policyItem
          }
        });
      }
    }).catch(err => {
      toasts.addDanger({
        'data-test-subj': 'policyDetailsFailureMessage',
        title: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.updateErrorTitle', {
          defaultMessage: 'Failed!'
        }),
        text: err.message
      });
    });
    handleSaveCancel();
  }, [dispatch, handleSaveCancel, navigateToApp, policy, policyName, policySettings, routeState, sendPolicyUpdate, toasts]);
  (0, _react.useEffect)(() => {
    if (!routeState && locationRouteState) {
      setRouteState(locationRouteState);
    }
  }, [locationRouteState, routeState]);
  (0, _react.useEffect)(() => {
    setUnsavedChanges(policyModified);
  }, [policyModified, setUnsavedChanges]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, showConfirm && /*#__PURE__*/_react.default.createElement(_policy_form_confirm_update.ConfirmUpdate, {
    endpointCount: agentSummaryData ? agentSummaryData.all : 0,
    onCancel: handleSaveCancel,
    onConfirm: handleSaveConfirmation
  }), /*#__PURE__*/_react.default.createElement(_policy_settings_form.PolicySettingsForm, {
    policy: policySettings,
    onChange: handleSettingsOnChange,
    mode: isEditMode ? 'edit' : 'view',
    "data-test-subj": "endpointPolicyForm"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xxl"
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.BottomBar, {
    paddingSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd",
    gutterSize: "s"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    color: "text",
    onClick: handleCancelOnClick,
    "data-test-subj": "policyDetailsCancelButton",
    disabled: isUpdating
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.cancel",
    defaultMessage: "Cancel"
  }))), isEditMode && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    disabled: !policyModified,
    fill: true,
    iconType: "save",
    "data-test-subj": "policyDetailsSaveButton",
    onClick: handleSaveOnClick,
    isLoading: isUpdating
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.save",
    defaultMessage: "Save"
  }))))));
});
PolicySettingsLayout.displayName = 'PolicySettingsLayout';