"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicySettingsForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _update_antivirus_registration_enabled = require("../../../../../../common/endpoint/utils/update_antivirus_registration_enabled");
var _use_get_protections_unavailable_component = require("./hooks/use_get_protections_unavailable_component");
var _antivirus_registration_card = require("./components/cards/antivirus_registration_card");
var _linux_event_collection_card = require("./components/cards/linux_event_collection_card");
var _mac_event_collection_card = require("./components/cards/mac_event_collection_card");
var _windows_event_collection_card = require("./components/cards/windows_event_collection_card");
var _attack_surface_reduction_card = require("./components/cards/attack_surface_reduction_card");
var _behaviour_protection_card = require("./components/cards/protection_seetings_card/behaviour_protection_card");
var _memory_protection_card = require("./components/cards/memory_protection_card");
var _related_detection_rules_callout = require("./components/related_detection_rules_callout");
var _ransomware_protection_card = require("./components/cards/ransomware_protection_card");
var _malware_protections_card = require("./components/cards/malware_protections_card");
var _advanced_section = require("./components/advanced_section");
var _use_test_id_generator = require("../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PROTECTIONS_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.protections', {
  defaultMessage: 'Protections'
});
const SETTINGS_SECTION_TITLE = _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.settings', {
  defaultMessage: 'Settings'
});
const PolicySettingsForm = exports.PolicySettingsForm = /*#__PURE__*/(0, _react.memo)(props => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(props['data-test-subj']);
  const ProtectionsUpSellingComponent = (0, _use_get_protections_unavailable_component.useGetProtectionsUnavailableComponent)();
  const onChangeProxy = ({
    isValid,
    updatedPolicy
  }) => {
    // perform tasks that synchronises changes between settings
    (0, _update_antivirus_registration_enabled.updateAntivirusRegistrationEnabled)(updatedPolicy);
    props.onChange({
      isValid,
      updatedPolicy
    });
  };
  return /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": getTestId()
  }, /*#__PURE__*/_react.default.createElement(FormSectionTitle, null, PROTECTIONS_SECTION_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), ProtectionsUpSellingComponent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(ProtectionsUpSellingComponent, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), !ProtectionsUpSellingComponent && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_related_detection_rules_callout.RelatedDetectionRulesCallout, null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_malware_protections_card.MalwareProtectionsCard, (0, _extends2.default)({}, props, {
    onChange: onChangeProxy,
    "data-test-subj": getTestId('malware')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_ransomware_protection_card.RansomwareProtectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('ransomware')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_memory_protection_card.MemoryProtectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('memory')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_behaviour_protection_card.BehaviourProtectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('behaviour')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_attack_surface_reduction_card.AttackSurfaceReductionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('attackSurface')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })), /*#__PURE__*/_react.default.createElement(FormSectionTitle, null, SETTINGS_SECTION_TITLE), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_windows_event_collection_card.WindowsEventCollectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('windowsEvents')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_mac_event_collection_card.MacEventCollectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('macEvents')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_linux_event_collection_card.LinuxEventCollectionCard, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('linuxEvents')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_antivirus_registration_card.AntivirusRegistrationCard, (0, _extends2.default)({}, props, {
    onChange: onChangeProxy,
    "data-test-subj": getTestId('antivirusRegistration')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_advanced_section.AdvancedSection, (0, _extends2.default)({}, props, {
    "data-test-subj": getTestId('advancedSection')
  })));
});
PolicySettingsForm.displayName = 'PolicySettingsForm';
const FormSectionTitle = /*#__PURE__*/(0, _react.memo)(({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement("h4", null, children));
});
FormSectionTitle.displayName = 'FormSectionTitle';