"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingLockedCard = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _i18n = require("@kbn/i18n");
var _use_test_id_generator = require("../../../../../hooks/use_test_id_generator");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const LockedPolicyDiv = _styledComponents.default.div`
  .euiCard__betaBadgeWrapper {
    .euiCard__betaBadge {
      width: auto;
    }
  }
  .lockedCardDescription {
    padding: 0 33.3%;
  }
`;
const SettingLockedCard = exports.SettingLockedCard = /*#__PURE__*/(0, _react.memo)(({
  title,
  'data-test-subj': dataTestSubj
}) => {
  const getTestId = (0, _use_test_id_generator.useTestIdGenerator)(dataTestSubj);
  return /*#__PURE__*/_react.default.createElement(LockedPolicyDiv, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    "data-test-subj": getTestId(),
    betaBadgeProps: {
      'data-test-subj': getTestId('badge'),
      label: _i18n.i18n.translate('xpack.securitySolution.endpoint.policy.details.platinum', {
        defaultMessage: 'Platinum'
      })
    },
    isDisabled: true,
    icon: /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      size: "xl",
      type: "lock"
    }),
    title: /*#__PURE__*/_react.default.createElement("h3", {
      "data-test-subj": getTestId('title')
    }, /*#__PURE__*/_react.default.createElement("strong", null, title)),
    description: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    className: "lockedCardDescription",
    direction: "column",
    gutterSize: "none"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.upgradeToPlatinum",
    defaultMessage: "Upgrade to Elastic Platinum"
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.endpoint.policy.details.lockedCardUpgradeMessage",
    defaultMessage: "To turn on this protection, you must upgrade your license to Platinum, start a free 30-day trial, or spin up a {cloudDeploymentLink} on AWS, GCP, or Azure.",
    values: {
      cloudDeploymentLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: "https://www.elastic.co/cloud/",
        target: "_blank",
        "data-test-subj": getTestId('cloudLink')
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.endpoint.policy.details.cloudDeploymentLInk",
        defaultMessage: "cloud deployment"
      }))
    }
  })))))));
});
SettingLockedCard.displayName = 'SettingLockedCard';