"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PolicyArtifactsAssignableList = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _artifact_entry_card = require("../../../../../components/artifact_entry_card");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PolicyArtifactsAssignableList = exports.PolicyArtifactsAssignableList = /*#__PURE__*/_react.default.memo(({
  artifacts,
  isListLoading,
  selectedArtifactIds,
  selectedArtifactsUpdated
}) => {
  const selectedArtifactIdsByKey = (0, _react.useMemo)(() => selectedArtifactIds.reduce((acc, current) => ({
    ...acc,
    [current]: true
  }), {}), [selectedArtifactIds]);
  const assignableList = (0, _react.useMemo)(() => {
    if (!artifacts || !artifacts.data.length) return null;
    const items = artifacts.data;
    return /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "artifactsList"
    }, items.map(artifact => /*#__PURE__*/_react.default.createElement(_artifact_entry_card.ArtifactEntryCardMinified, {
      key: artifact.id,
      item: artifact,
      isSelected: selectedArtifactIdsByKey[artifact.id] || false,
      onToggleSelectedArtifact: selected => selectedArtifactsUpdated(artifact.id, selected)
    })));
  }, [artifacts, selectedArtifactIdsByKey, selectedArtifactsUpdated]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isListLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiProgress, {
    size: "xs",
    color: "primary",
    "data-test-subj": "artifactsAssignableListLoader"
  }), /*#__PURE__*/_react.default.createElement("div", null, assignableList));
});
PolicyArtifactsAssignableList.displayName = 'PolicyArtifactsAssignableList';