"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EndpointListNavLink = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _use_navigate_by_router_event_handler = require("../../../../../common/hooks/endpoint/use_navigate_by_router_event_handler");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EndpointListNavLink = exports.EndpointListNavLink = /*#__PURE__*/(0, _react.memo)(({
  name,
  href,
  route,
  dataTestSubj
}) => {
  const clickHandler = (0, _use_navigate_by_router_event_handler.useNavigateByRouterEventHandler)(route);
  return (
    /*#__PURE__*/
    // eslint-disable-next-line @elastic/eui/href-or-on-click
    _react.default.createElement(_eui.EuiLink, {
      "data-test-subj": dataTestSubj,
      className: "eui-displayInline eui-textTruncate",
      href: href,
      onClick: clickHandler
    }, name)
  );
});
EndpointListNavLink.displayName = 'EndpointListNavLink';