"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OfflineCallout = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_experimental_features = require("../../../../common/hooks/use_experimental_features");
var _use_sentinelone_host_isolation = require("../../../../detections/components/host_isolation/use_sentinelone_host_isolation");
var _hooks = require("../../../hooks");
var _types = require("../../../../../common/endpoint/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OfflineCallout = exports.OfflineCallout = /*#__PURE__*/(0, _react.memo)(({
  agentType,
  endpointId,
  hostName
}) => {
  const isEndpointAgent = agentType === 'endpoint';
  const isSentinelOneAgent = agentType === 'sentinel_one';
  const isSentinelOneV1Enabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('responseActionsSentinelOneV1Enabled');
  const sentinelOneManualHostActionsEnabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('sentinelOneManualHostActionsEnabled');
  const {
    data: endpointDetails
  } = (0, _hooks.useGetEndpointDetails)(endpointId, {
    refetchInterval: 10000,
    enabled: isEndpointAgent
  });
  const {
    data
  } = (0, _use_sentinelone_host_isolation.useGetSentinelOneAgentStatus)([endpointId], {
    enabled: sentinelOneManualHostActionsEnabled && isSentinelOneAgent
  });

  // TODO: simplify this to use the yet to be implemented agentStatus API hook
  const showOfflineCallout = (0, _react.useMemo)(() => isEndpointAgent && (endpointDetails === null || endpointDetails === void 0 ? void 0 : endpointDetails.host_status) === _types.HostStatus.OFFLINE || isSentinelOneAgent && (data === null || data === void 0 ? void 0 : data[endpointId].status) === _types.HostStatus.OFFLINE, [data, endpointDetails === null || endpointDetails === void 0 ? void 0 : endpointDetails.host_status, endpointId, isEndpointAgent, isSentinelOneAgent]);
  if (isEndpointAgent && !endpointDetails || isSentinelOneV1Enabled && isSentinelOneAgent && !data) {
    return null;
  }
  if (showOfflineCallout) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      iconType: "offline",
      color: "warning",
      "data-test-subj": "offlineCallout",
      title: _i18n.i18n.translate('xpack.securitySolution.responder.hostOffline.callout.title', {
        defaultMessage: 'Host Offline'
      })
    }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.responder.hostOffline.callout.body",
      defaultMessage: "The host {name} is offline, so its responses may be delayed. Pending commands will execute when the host reconnects.",
      values: {
        name: /*#__PURE__*/_react.default.createElement("strong", null, hostName)
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }));
  }
  return null;
});
OfflineCallout.displayName = 'OfflineCallout';