"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderSentinelOneInfo = void 0;
var _react = _interopRequireWildcard(require("react"));
var _use_experimental_features = require("../../../../../../common/hooks/use_experimental_features");
var _use_sentinelone_host_isolation = require("../../../../../../detections/components/host_isolation/use_sentinelone_host_isolation");
var _sentinel_one_agent_status = require("../../../../../../detections/components/host_isolation/sentinel_one_agent_status");
var _header_agent_info = require("../header_agent_info");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const HeaderSentinelOneInfo = exports.HeaderSentinelOneInfo = /*#__PURE__*/(0, _react.memo)(({
  agentId,
  platform,
  hostName
}) => {
  const isSentinelOneV1Enabled = (0, _use_experimental_features.useIsExperimentalFeatureEnabled)('sentinelOneManualHostActionsEnabled');
  const {
    data
  } = (0, _use_sentinelone_host_isolation.useGetSentinelOneAgentStatus)([agentId], {
    enabled: isSentinelOneV1Enabled
  });
  const agentStatus = data === null || data === void 0 ? void 0 : data[agentId];
  const lastCheckin = agentStatus ? agentStatus.lastSeen : '';
  return /*#__PURE__*/_react.default.createElement(_header_agent_info.HeaderAgentInfo, {
    platform: platform.toLowerCase(),
    hostName: hostName,
    lastCheckin: lastCheckin
  }, /*#__PURE__*/_react.default.createElement(_sentinel_one_agent_status.SentinelOneAgentStatus, {
    agentId: agentId,
    "data-test-subj": "responderHeaderSentinelOneAgentIsolationStatus"
  }));
});
HeaderSentinelOneInfo.displayName = 'HeaderSentinelOneInfo';