"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PlatformIcon = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _linux = _interopRequireDefault(require("./logos/linux.svg"));
var _windows = _interopRequireDefault(require("./logos/windows.svg"));
var _macos = _interopRequireDefault(require("./logos/macos.svg"));
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getPlatformIcon = platform => {
  switch (platform) {
    case 'macos':
      return _macos.default;
    case 'linux':
      return _linux.default;
    case 'windows':
      return _windows.default;
    default:
      return null;
  }
};
const PlatformIcon = exports.PlatformIcon = /*#__PURE__*/(0, _react.memo)(({
  platform,
  size = 'xl',
  'data-test-subj': dataTestSubj
}) => {
  const platformIcon = (0, _react.useMemo)(() => getPlatformIcon(platform), [platform]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: !platformIcon ? 'empty' : platformIcon,
    title: platform,
    size: size,
    "data-test-subj": dataTestSubj
  });
});
PlatformIcon.displayName = 'PlatformIcon';